package com.biz.crm.cps.business.product.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 物料维度Vo 包含所属 品牌 大类 细类 系列
 *
 * @Author: hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialDimensionVo", description = "物料维度Vo ")
public class MaterialDimensionVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 870828809784273949L;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;
  /**
   * 层级编码
   */
  @ApiModelProperty("层级编码")
  private String productLevelCode;
  /**
   * 商品所属层级
   */
  @ApiModelProperty("商品所属层级")
  private Set<ProductLevelVo> productLevels;

  /**
   * 商品与物料关系
   */
  @ApiModelProperty("商品与物料关系")
  private Set<ProductMaterialVo> productMaterials;
  /**
   * 物料组关系
   */
  @ApiModelProperty("物料组关系")
  private Set<MaterialGroupRelVo> materialGroupRels;
}
