package com.biz.crm.cps.business.product.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import java.math.BigDecimal;
import java.util.List;

/**
 * 物料标箱信息Vo
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialStandardUnitVos", description = "物料标箱信息Vo")
public class MaterialStandardUnitVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7755748861593003607L;
  /**
   * 条码
   */
  @ApiModelProperty("条码")
  private String barCode;
  /**
   * 条码
   */
  @ApiModelProperty("条码类型")
  private String barCodeType;
  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;
  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;
  /**
   * 标准单位转换结果 数值+描述 0.5标箱
   */
  @ApiModelProperty("标准单位结果")
  private String standardUnit;
  /**
   * 标准单位转换结果 数值 0.5
   */
  @ApiModelProperty("标准单位结果")
  private BigDecimal standardUnitValue;
  /**
   * 标准单位 case
   */
  @ApiModelProperty("标准单位")
  private String standardUnitType;
  /**
   * 标准单位描述 标箱
   */
  @ApiModelProperty("标准单位描述")
  private String standardUnitTypeDesc;
  /**
   * 标准单位转换描述
   */
  @ApiModelProperty("标准单位转换描述")
  private List<String> standardUnitDesc;

}
