package com.biz.crm.cps.business.product.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 物料信息Vo
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "MaterialVo", description = "物料信息Vo")
public class MaterialVo extends TenantFlagOpVo {
  private static final long serialVersionUID = 7755748861593003607L;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 物料名称
   */
  @ApiModelProperty("物料名称")
  private String materialName;


  /**
   * ai编码
   */
  @ApiModelProperty("ai编码")
  private String aiCode;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  private String baseUnit;

  /**
   * 物料类型 {@link MaterialTypeEnum}
   *
   * <pre>
   * "big":"大"
   * "small", "小"
   * "bzsp": "标准商品"
   * "cx":"促销品"
   * "finished_product":"产成品"
   * "marketing_materials":"营销物料"
   * </pre>
   */
  @ApiModelProperty("物料类型")
  private String materialType;

  /**
   * 销售公司
   */
  @ApiModelProperty("销售公司")
  private String saleCompany;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String specification;

  /**
   * 单位换算系数
   */
  @ApiModelProperty("单位换算系数")
  private String unitConversion;

  /**
   * 成本价格
   */
  @ApiModelProperty("成本价格")
  private BigDecimal costPrice;

  /**
   * 毛重
   */
  @ApiModelProperty("毛重")
  private String grossWeight;

  /**
   * 净重
   */
  @ApiModelProperty("净重")
  private String netWeight;

  /**
   * 容量
   */
  @ApiModelProperty("容量")
  private String capacity;


  /**
   * 外部 唯一标识
   *
   * @Column(name = "external_identifier", nullable = true, length = 64, columnDefinition =
   * "VARCHAR(64) COMMENT ' 外部 唯一标识 '")
   */
  @ApiModelProperty("外部唯一标识")
  private String externalIdentifier;

  /**
   * 标准单位
   */
  @ApiModelProperty("标准单位")
  private String standardUnit;

  /**
   * 盒码单位转算系数
   */
  @ApiModelProperty("盒码单位转算系数")
  private BigDecimal boxUnitConversion;

  /**
   * 箱码单位转算系数
   */
  @ApiModelProperty("箱码单位转算系数")
  private BigDecimal caseUnitConversion;
}
