package com.biz.crm.cps.business.product.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Set;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品维度Vo 包含所属 品牌 大类 细类 系列
 *
 * @Author: hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductDimensionVo", description = "商品维度Vo ")
public class ProductDimensionVo extends TenantFlagOpVo {

  private static final long serialVersionUID = 7179221587355580837L;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;
  /**
   * 商品层级编码
   */
  @ApiModelProperty("商品层级编码")
  private String productLevelCode;
  /**
   * 商品所属层级
   */
  @ApiModelProperty("商品所属层级")
  private Set<ProductLevelVo> productLevels;

  /**
   * 商品与物料关系
   */
  @ApiModelProperty("商品与物料关系")
  private Set<ProductMaterialVo> productMaterials;
}
