package com.biz.crm.cps.business.product.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品层级Vo 包含所属 品牌 大类 细类 系列
 *
 * @Author: hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductLevelVo", description = "商品层级 包含所属 品牌 大类 细类 系列")
public class ProductLevelVo extends TenantFlagOpVo {
  
  private static final long serialVersionUID = 1453583958989676388L;
  /**
   * 商品层级code
   */
  @ApiModelProperty("商品层级code")
  private String productLevelCode;
  /**
   * 商品层级name
   */
  @ApiModelProperty("商品层级name")
  private String productLevelName;
  /**
   * 商品层级type
   */
  @ApiModelProperty("商品层级type")
  private String productLevelType;

}
