package com.biz.crm.cps.business.product.sdk.vo;

import com.biz.crm.business.common.sdk.vo.UuidFlagOpVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

/**
 * 商品物料关系Vo
 *
 * @author hecheng
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Api(tags = "商品与物料关系实体Vo")
public class ProductMaterialVo extends UuidFlagOpVo {
  
  private static final long serialVersionUID = 2385892762878185750L;

  /**
   * 物料数量
   */
  @ApiModelProperty("物料数量")
  private Integer num;

  /**
   * 物料编码
   */
  @ApiModelProperty("物料编码")
  private String materialCode;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 比例
   */
  @ApiModelProperty("比例")
  private BigDecimal ratio;

}
