package com.biz.crm.cps.business.product.sdk.vo;
import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductShelfStatusEnum;
import com.biz.crm.cps.business.product.sdk.common.enums.ProductTypeEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商品主表实体类
 *
 * @author hecheng
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ProductVo", description = "商品信息Vo")
public class ProductVo extends TenantFlagOpVo {

  /**
   * 
   */
  private static final long serialVersionUID = -1875247100253082848L;

  /**
   * 商品编码
   */
  @ApiModelProperty("商品编码")
  private String productCode;

  /**
   * 商品名称
   */
  @ApiModelProperty("商品名称")
  private String productName;

  /**
   * 产品层级编码
   */
  @ApiModelProperty("产品层级编码")
  private String productLevelCode;

  /**
   * 商品类型(数据字典) {@link ProductTypeEnum}
   * <pre>"gift_package":"礼包商品"
   * "range":"范围商品"
   * "standard":"标准商品"</pre>
   */
  @ApiModelProperty("商品类型")
  private String productType;

  /**
   * 上下架状态(数据字典){@link ProductShelfStatusEnum} "Y","上架"；"N","下架"
   */
  @ApiModelProperty("上下架状态")
  private String isShelf;

  /**
   * 条形码
   */
  @ApiModelProperty("条形码")
  private String barCode;

  /**
   * 销售公司
   */
  @ApiModelProperty("销售公司")
  private String saleCompany;

  /**
   * 主图片url
   */
  @ApiModelProperty("主图片url")
  private String primaryPictureUrl;

  /**
   * 销售单位
   */
  @ApiModelProperty("销售单位")
  private String saleUnit;

  /**
   * 规格
   */
  @ApiModelProperty("规格")
  private String spec;
  /**
   * 基本单位
   */
  @ApiModelProperty("基本单位")
  private String baseUnit;
  /**
   * 外部 唯一标识
   */
  @ApiModelProperty("外部唯一标识")
  private String externalIdentifier;
}
