/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.service.builder;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.ladder.service.builder.QuantifyTaskBuilder;
import com.biz.crm.cps.business.policy.quantify.ladder.utils.QuantifyUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class QuantifyTaskYearBuilder
implements QuantifyTaskBuilder {
    @Override
    public String quantifyTaskCycle() {
        return "year";
    }

    @Override
    public List<QuantifyTask> assemblyQuantifyTask(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo) {
        ArrayList taskList = Lists.newArrayList();
        if (!ObjectUtils.allNotNull((Object[])new Object[]{agreementVo, agreementLadderVo})) {
            return taskList;
        }
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        Date now = new Date();
        QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        if (effectiveTime.before(now)) {
            effectiveTime = now;
            statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            int addMonths = nowMonth % 12;
            QuantifyTask quantifyTask = new QuantifyTask();
            quantifyTask.setTaskStartTime(effectiveTime);
            effectiveTime = addMonths == 0 ? DateUtils.ceiling((Date)effectiveTime, (int)2) : DateUtils.ceiling((Date)effectiveTime, (int)1);
            quantifyTask.setTaskEndTime(DateUtils.addSeconds((Date)effectiveTime, (int)-1));
            quantifyTask.setTaskName(nowYear + "\u5e74\u5ea6\u5305\u91cf\u4efb\u52a1");
            quantifyTask.setTaskStatus(statusEnum.getCode());
            quantifyTask.setSaleTarget(QuantifyUtils.getScaleByTimeInterval(DateUtils.setMonths((Date)quantifyTask.getTaskStartTime(), (int)0), quantifyTask.getTaskEndTime(), agreementLadderVo));
            taskList.add(quantifyTask);
            statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        }
        return taskList;
    }
}

