/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.service.internal;

import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.TemplateOrgRelationshipVo;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyExpression;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyConfigurationRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyExpressionRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyPolicyRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyRangeRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.ladder.service.observer.QuantifyPolicyMountRegisterImpl;
import com.biz.crm.cps.business.policy.quantify.ladder.service.observer.QuantifyPolicyPojoObserverRegister;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class QuantifyPolicyServiceImpl
implements QuantifyPolicyService {
    @Autowired
    private QuantifyPolicyPojoObserverRegister policyPojoObserver;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private QuantifyPolicyRepository quantifyPolicyRepository;
    @Autowired
    private QuantifyConfigurationRepository quantifyConfigurationRepository;
    @Autowired
    private QuantifyRangeRepository quantifyRangeRepository;
    @Autowired
    private QuantifyExpressionRepository quantifyExpressionRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired
    private AgreementTemplateVoService agreementTemplateVoService;
    @Autowired
    @Qualifier(value="QuantifyPolicyMountRegisterImpl")
    private QuantifyPolicyMountRegisterImpl quantifyPolicyMountRegister;
    @Autowired
    private MaterialVoService materialVoService;

    @Override
    @Transactional
    public QuantifyPolicy create(AgreementPolicyDto agreementPolicyDto) {
        if (agreementPolicyDto == null) {
            return null;
        }
        QuantifyPolicy quantifyPolicy = (QuantifyPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementPolicyDto, QuantifyPolicy.class, HashSet.class, ArrayList.class, new String[]{"quantifyConfigurations", "quantifyConfigurations.quantifyRanges", "quantifyConfigurations.quantifyExpressions"}));
        return this.createFrom(quantifyPolicy);
    }

    @Override
    @Transactional
    public QuantifyPolicy createFrom(QuantifyPolicy quantifyPolicy) {
        this.createValidation(quantifyPolicy);
        Date now = new Date();
        quantifyPolicy.setCreateTime(now);
        quantifyPolicy.setModifyTime(now);
        quantifyPolicy.setCreateAccount(this.loginUserService.getLoginAccountName());
        quantifyPolicy.setModifyAccount(this.loginUserService.getLoginAccountName());
        this.quantifyPolicyRepository.save((Object)quantifyPolicy);
        ArrayList dimensionCodes = Lists.newArrayList();
        quantifyPolicy.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            quantifyConfiguration.setQuantifyPolicyId(quantifyPolicy.getId());
            this.quantifyConfigurationRepository.save(quantifyConfiguration);
            quantifyConfiguration.getQuantifyExpressions().forEach(quantifyExpression -> quantifyExpression.setConfigurationId(quantifyConfiguration.getId()));
            this.quantifyExpressionRepository.saveBatch(quantifyConfiguration.getQuantifyExpressions());
            if (!"DIMENSION_ALL".equals(quantifyPolicy.getDimensionFlag())) {
                quantifyConfiguration.getQuantifyRanges().forEach(quantifyRange -> {
                    dimensionCodes.add(quantifyRange.getSpecialCode());
                    quantifyRange.setConfigurationId(quantifyConfiguration.getId());
                });
                this.quantifyRangeRepository.saveBatch(quantifyConfiguration.getQuantifyRanges());
            }
        });
        CompletableFuture.runAsync(() -> this.materialVoService.sync(dimensionCodes, quantifyPolicy.getDimensionFlag()));
        return quantifyPolicy;
    }

    @Override
    public QuantifyPolicy findDetailByTemplateCode(String templateCode) {
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            return null;
        }
        return this.quantifyPolicyRepository.findDetailByTemplateCode(templateCode);
    }

    @Override
    public QuantifyPolicy findById(String id) {
        return this.quantifyPolicyRepository.findDetailById(id);
    }

    @Override
    public QuantifyPolicy findByTemplateCode(String templateCode) {
        return this.quantifyPolicyRepository.findDetailByTemplateCode(templateCode);
    }

    private void createValidation(QuantifyPolicy entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        if (StringUtils.isBlank((CharSequence)entity.getTenantCode())) {
            entity.setTenantCode(TenantUtils.getTenantCode());
        }
        Validate.notBlank((CharSequence)entity.getDimensionFlag(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getDimensionName(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!CollectionUtils.isEmpty(entity.getQuantifyConfigurations()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u914d\u7f6e\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        entity.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            if (!"DIMENSION_ALL".equals(entity.getDimensionFlag())) {
                Validate.isTrue((!CollectionUtils.isEmpty(quantifyConfiguration.getQuantifyRanges()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u4ea7\u54c1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
            Validate.notBlank((CharSequence)quantifyConfiguration.getAgreementLadderCode(), (String)"\u653f\u7b56\u5173\u8054\u534f\u8bae\u9636\u68af\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)quantifyConfiguration.getOnlyHighestLevel(), (String)"\u8bf7\u786e\u8ba4\u662f\u5426\u53ea\u4f7f\u7528\u6700\u9ad8\u6bd4\u4f8b\u5206\u5229\uff01", (Object[])new Object[0]);
            Validate.isTrue((!CollectionUtils.isEmpty(quantifyConfiguration.getQuantifyExpressions()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u5206\u5229\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            quantifyConfiguration.getQuantifyRanges().forEach(this::quantifyRangeValidation);
            quantifyConfiguration.getQuantifyExpressions().forEach(this::quantifyExpressionValidation);
            HashMap expressionMap = new HashMap();
            quantifyConfiguration.getQuantifyExpressions().forEach(quantifyExpression -> {
                ArrayList<String> rewardMethods = (ArrayList<String>)expressionMap.get(quantifyExpression.getReachRate());
                if (CollectionUtils.isEmpty((Collection)rewardMethods)) {
                    rewardMethods = new ArrayList<String>();
                }
                Validate.isTrue((!rewardMethods.contains(quantifyExpression.getRewardMethodFlag() + "," + quantifyExpression.getCalculateCycle()) ? 1 : 0) != 0, (String)"\u540c\u4e00\u5206\u5229\u6bd4\u4f8b\u4e0b\u540c\u4e00\u79cd\u5206\u5229\u65b9\u5f0f\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a", (Object[])new Object[0]);
                rewardMethods.add(quantifyExpression.getRewardMethodFlag() + "," + quantifyExpression.getCalculateCycle());
                expressionMap.put(quantifyExpression.getReachRate(), rewardMethods);
            });
        });
    }

    private void quantifyExpressionValidation(QuantifyExpression entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getRewardMethodFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRewardMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u5956\u52b1\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getAwardConditionFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u5956\u52b1\u6761\u4ef6\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getAwardConditionName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u5956\u52b1\u6761\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getCalculateCycle(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u7ed3\u7b97\u5468\u671f\u7ed3\u7b97\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getReachRate(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u9636\u68af\u8fbe\u6210\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getReachRate().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u9636\u68af\u8fbe\u6210\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getRewardData(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u5956\u52b1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getRewardData().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5305\u91cf\u5206\u5229\u8868\u8fbe\u5f0f\u5956\u52b1\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
    }

    private void quantifyRangeValidation(QuantifyRange entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getSpecialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getSpecialName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    public void validatePolicyScope(AgreementTemplateVo agreementTemplateVo, AgreementPolicyDto agreementPolicyDto) {
        ProfitAgreementTemplatePaginationDto templatePaginationDto = new ProfitAgreementTemplatePaginationDto();
        if (!CollectionUtils.isEmpty((Collection)agreementTemplateVo.getTemplateOrgRelationships())) {
            List orgCodes = agreementTemplateVo.getTemplateOrgRelationships().stream().map(TemplateOrgRelationshipVo::getOrgCode).collect(Collectors.toList());
            templatePaginationDto.setOrgCodes(orgCodes);
        }
        templatePaginationDto.setPolicyCode(this.quantifyPolicyMountRegister.getKey());
        templatePaginationDto.setEffectiveScopeStartTime(agreementTemplateVo.getEffectiveStartTime());
        templatePaginationDto.setEffectiveScopeEndTime(agreementTemplateVo.getEffectiveEndTime());
        templatePaginationDto.setStatus(EnableStatusEnum.ENABLE.getCode());
        List templateVos = this.agreementTemplateVoService.findByConditions(templatePaginationDto);
        if (CollectionUtils.isEmpty((Collection)templateVos)) {
            return;
        }
        QuantifyPolicy quantifyPolicy = (QuantifyPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementPolicyDto, QuantifyPolicy.class, HashSet.class, ArrayList.class, new String[]{"quantifyConfigurations", "quantifyConfigurations.quantifyRanges", "quantifyConfigurations.quantifyExpressions"}));
        List templateCodes = templateVos.stream().map(AgreementTemplateVo::getTemplateCode).collect(Collectors.toList());
        QuantifyPolicyDto quantifyPolicyDto = new QuantifyPolicyDto();
        quantifyPolicyDto.setTemplateCodes(templateCodes);
        List<QuantifyPolicy> quantifyPolicies = this.quantifyPolicyRepository.findByConditions(quantifyPolicyDto);
        if (CollectionUtils.isEmpty(quantifyPolicies)) {
            return;
        }
        Map<String, Map<Boolean, List<String>>> ladderRangeMap = this.policyLadderValidation(quantifyPolicy);
        quantifyPolicies.forEach(policy -> {
            Map<String, Map<Boolean, List<String>>> oldLadderRangeMap = this.policyLadderValidation((QuantifyPolicy)((Object)policy));
            oldLadderRangeMap.forEach((key, value) -> {
                if (ladderRangeMap.containsKey(key)) {
                    Map rangeMap = (Map)ladderRangeMap.get(key);
                    Validate.isTrue((rangeMap.containsKey(false) && value.containsKey(false) ? 1 : 0) != 0, (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u5305\u542b\u5168\u90e8\u4ea7\u54c1\uff01", (Object[])new Object[0]);
                    ((List)value.get(false)).retainAll((Collection)rangeMap.get(false));
                    Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)((Collection)value.get(false))), (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u51fa\u73b0\u7269\u6599\u91cd\u590d", (Object[])new Object[0]);
                }
            });
        });
    }

    private List<String> policyRangeValidation(QuantifyPolicy quantifyPolicy) {
        ArrayList materialCodes = Lists.newArrayList();
        Validate.isTrue((!CollectionUtils.isEmpty(quantifyPolicy.getQuantifyConfigurations()) ? 1 : 0) != 0, (String)"\u5305\u91cf\u653f\u7b56\u5fc5\u987b\u5305\u542b\u914d\u7f6e\uff01", (Object[])new Object[0]);
        quantifyPolicy.getQuantifyConfigurations().forEach(configuration -> {
            Validate.isTrue((!CollectionUtils.isEmpty(configuration.getQuantifyRanges()) ? 1 : 0) != 0, (String)"\u5305\u91cf\u653f\u7b56\u914d\u7f6e\u5fc5\u987b\u914d\u7f6e\u4ea7\u54c1\u7ef4\u5ea6\u8303\u56f4\uff01", (Object[])new Object[0]);
            List materialCodeList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList()), quantifyPolicy.getDimensionFlag());
            if (!CollectionUtils.isEmpty((Collection)materialCodeList)) {
                materialCodes.addAll(materialCodeList);
            }
        });
        return materialCodes;
    }

    @Override
    public List<QuantifyPolicy> findByConditions(QuantifyPolicyDto quantifyPolicyDto) {
        if (Objects.isNull(quantifyPolicyDto)) {
            return null;
        }
        return this.quantifyPolicyRepository.findByConditions(quantifyPolicyDto);
    }

    private Map<String, Map<Boolean, List<String>>> policyLadderValidation(QuantifyPolicy quantifyPolicy) {
        HashMap ladderRangeMap = Maps.newHashMap();
        quantifyPolicy.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            Validate.notEmpty((CharSequence)quantifyConfiguration.getAgreementLadderCode(), (String)"\u521b\u5efa\u5305\u91cf\u653f\u7b56\u65f6\u9636\u68af\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            HashMap rangeMap = Maps.newHashMap();
            if ("DIMENSION_ALL".equals(quantifyPolicy.getDimensionFlag())) {
                rangeMap.put(true, Lists.newArrayList());
            } else {
                rangeMap.put(false, this.policyRangeValidation(quantifyPolicy));
            }
            if (ladderRangeMap.containsKey(quantifyConfiguration.getAgreementLadderCode())) {
                Map oldRangeMap = (Map)ladderRangeMap.get(quantifyConfiguration.getAgreementLadderCode());
                Validate.isTrue((oldRangeMap.containsKey(false) && rangeMap.containsKey(false) ? 1 : 0) != 0, (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u5305\u542b\u5168\u90e8\u4ea7\u54c1\uff01", (Object[])new Object[0]);
                ArrayList oldRanges = Lists.newArrayList();
                oldRanges.addAll((Collection)oldRangeMap.get(false));
                oldRanges.retainAll((Collection)rangeMap.get(false));
                Validate.isTrue((boolean)CollectionUtils.isEmpty((Collection)oldRanges), (String)"\u591a\u4e2a\u653f\u7b56\u914d\u7f6e\u5171\u7528\u540c\u4e00\u4e2a\u534f\u8bae\u9636\u68af\u5e76\u51fa\u73b0\u7269\u6599\u91cd\u590d", (Object[])new Object[0]);
                ((List)rangeMap.get(false)).addAll((Collection)oldRangeMap.get(false));
            }
            ladderRangeMap.put(quantifyConfiguration.getAgreementLadderCode(), rangeMap);
        });
        return ladderRangeMap;
    }
}

