/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.utils;

import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;

public class QuantifyUtils {
    public static BigDecimal getScaleByMonth(int month, AgreementLadderVo agreementLadderVo) {
        switch (month) {
            case 1: {
                return agreementLadderVo.getJanuarySaleNum();
            }
            case 2: {
                return agreementLadderVo.getFebruarySaleNum();
            }
            case 3: {
                return agreementLadderVo.getMarchSaleNum();
            }
            case 4: {
                return agreementLadderVo.getAprilSaleNum();
            }
            case 5: {
                return agreementLadderVo.getMaySaleNum();
            }
            case 6: {
                return agreementLadderVo.getJuneSaleNum();
            }
            case 7: {
                return agreementLadderVo.getJulySaleNum();
            }
            case 8: {
                return agreementLadderVo.getAugustSaleNum();
            }
            case 9: {
                return agreementLadderVo.getSeptemberSaleNum();
            }
            case 10: {
                return agreementLadderVo.getOctoberSaleNum();
            }
            case 11: {
                return agreementLadderVo.getNovemberSaleNum();
            }
        }
        return agreementLadderVo.getDecemberSaleNum();
    }

    public static BigDecimal getScaleByTimeInterval(Date startTime, Date endTime, AgreementLadderVo agreementLadderVo) {
        BigDecimal target = BigDecimal.ZERO;
        while (startTime.before(endTime)) {
            target = target.add(QuantifyUtils.getScaleByMonth(startTime.getMonth() + 1, agreementLadderVo));
            startTime = DateUtils.ceiling((Date)startTime, (int)2);
        }
        return target;
    }
}

