/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.service.builder;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.ladder.service.builder.QuantifyTaskBuilder;
import com.biz.crm.cps.business.policy.quantify.ladder.utils.QuantifyUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Component;

@Component
public class QuantifyTaskSeasonBuilder
implements QuantifyTaskBuilder {
    @Override
    public String quantifyTaskCycle() {
        return "season";
    }

    @Override
    public List<QuantifyTask> assemblyQuantifyTask(AgreementVo agreementVo, AgreementLadderVo agreementLadderVo) {
        ArrayList taskList = Lists.newArrayList();
        if (!ObjectUtils.allNotNull((Object[])new Object[]{agreementVo, agreementLadderVo})) {
            return taskList;
        }
        Date effectiveTime = agreementVo.getEffectiveStartTime();
        Date now = new Date();
        QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        if (effectiveTime.before(now)) {
            effectiveTime = now;
            statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
        }
        while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(effectiveTime);
            int nowMonth = calendar.get(2) + 1;
            int nowYear = calendar.get(1);
            int addMonths = nowMonth % 3;
            QuantifyTask quantifyTask = new QuantifyTask();
            int nowSeason = nowMonth % 3 == 0 ? nowMonth / 3 : nowMonth / 3 + 1;
            quantifyTask.setTaskName(nowYear + "\u5e74\u7b2c" + nowSeason + "\u5b63\u5ea6\u5305\u91cf\u4efb\u52a1");
            quantifyTask.setTaskStatus(statusEnum.getCode());
            quantifyTask.setSaleTarget(QuantifyUtils.getScaleBySeason(nowMonth, agreementLadderVo));
            quantifyTask.setTaskStartTime(effectiveTime);
            effectiveTime = addMonths == 0 ? DateUtils.ceiling((Date)effectiveTime, (int)2) : DateUtils.addMonths((Date)DateUtils.ceiling((Date)effectiveTime, (int)2), (int)(3 - addMonths));
            quantifyTask.setTaskEndTime(DateUtils.addSeconds((Date)effectiveTime, (int)-1));
            taskList.add(quantifyTask);
            statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
        }
        return taskList;
    }
}

