/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyTaskDto;
import com.biz.crm.cps.business.agreement.sdk.common.enums.AutoSignEnum;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementDto;
import com.biz.crm.cps.business.agreement.sdk.dto.LoginUserAgreementDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementLadderVoService;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.participator.sdk.service.TerminalVoService;
import com.biz.crm.cps.business.participator.sdk.vo.TerminalVo;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyConfiguration;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyExpression;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTaskDetail;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTaskExpression;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyTaskDetailRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyTaskExpressionRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyTaskRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.ladder.service.QuantifyTaskService;
import com.biz.crm.cps.business.policy.quantify.ladder.service.builder.QuantifyTaskBuilder;
import com.biz.crm.cps.business.policy.quantify.ladder.service.observer.QuantifyPolicyMountRegisterImpl;
import com.biz.crm.cps.business.policy.quantify.ladder.utils.SchedulerUtils;
import com.biz.crm.cps.business.policy.sdk.dto.PolicyRewardConditionDto;
import com.biz.crm.cps.business.policy.sdk.service.observer.PolicyRewardServiceObserver;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.external.barcode.sdk.dto.ScanCodeRecordStatisticsDto;
import com.biz.crm.cps.external.barcode.sdk.service.ScanCodeRecordVoService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.bizunited.platform.task.annotations.DynamicTaskService;
import com.bizunited.platform.task.service.DynamicTaskSchedulerVoService;
import com.bizunited.platform.task.vo.DynamicTaskSchedulerVo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="quantifyTaskServiceImpl")
public class QuantifyTaskServiceImpl
implements QuantifyTaskService {
    @Autowired
    private AgreementVoService agreementVoService;
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;
    @Autowired
    private QuantifyTaskRepository quantifyTaskRepository;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private ScanCodeRecordVoService scanCodeRecordVoService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private List<PolicyRewardServiceObserver> policyRewardServiceObservers;
    @Autowired
    private DynamicTaskSchedulerVoService dynamicTaskSchedulerVoService;
    @Autowired
    private QuantifyTaskDetailRepository quantifyTaskDetailRepository;
    @Autowired
    private QuantifyPolicyMountRegisterImpl quantifyPolicyMountRegister;
    @Autowired
    private List<QuantifyTaskBuilder> quantifyTaskBuilderList;
    @Autowired
    private AgreementLadderVoService agreementLadderVoService;
    @Autowired
    private QuantifyTaskExpressionRepository quantifyTaskExpressionRepository;
    @Autowired
    private TerminalVoService terminalVoService;

    @Override
    @Transactional
    public List<QuantifyTask> create(String agreementId) {
        LoginUserAgreementDto loginUserAgreementDto = new LoginUserAgreementDto();
        loginUserAgreementDto.setAgreementCode(agreementId);
        AgreementDto agreementDto = new AgreementDto();
        agreementDto.setAgreementCode(agreementId);
        Page agreementVo = this.agreementVoService.findByConditions((Pageable)PageRequest.of((int)0, (int)50), agreementDto);
        if (agreementVo != null && !CollectionUtils.isEmpty((Collection)agreementVo.getRecords())) {
            return this.create((AgreementVo)agreementVo.getRecords().get(0));
        }
        return Lists.newArrayList();
    }

    @Override
    @Transactional
    public List<QuantifyTask> create(AgreementVo agreementVo) {
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyService.findByTemplateCode(agreementVo.getTemplateCode());
        Validate.notNull((Object)((Object)quantifyPolicy), (String)("\u534f\u8bae\u6a21\u677f\u7f16\u7801" + agreementVo.getAgreementCode() + "\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5305\u91cf\u653f\u7b56\uff01"), (Object[])new Object[0]);
        ArrayList quantifyTasks = Lists.newArrayList();
        quantifyPolicy.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            List<QuantifyTask> quantifyTaskList = this.buildQuantifyTask(agreementVo, (QuantifyConfiguration)((Object)quantifyConfiguration));
            if (!CollectionUtils.isEmpty(quantifyTaskList)) {
                quantifyTasks.addAll(quantifyTaskList);
            }
        });
        this.quantifyTaskRepository.saveBatch(quantifyTasks);
        quantifyTasks.forEach(quantifyTask -> this.quantifyTaskExpressionRepository.saveBatch(quantifyTask.getQuantifyTaskExpressions()));
        quantifyTasks.forEach(task -> {
            DynamicTaskSchedulerVo taskSchedulerVo = this.dynamicTaskSchedulerVoService.createIgnorePrefix(task.getBusinessCode(), "quantifyTaskServiceImpl", "triggerQuantityTask", SchedulerUtils.getSchedulerCron(task.getTaskType()), agreementVo.getEffectiveEndTime(), task.getTaskName(), new Object[]{task.getBusinessCode()});
            this.dynamicTaskSchedulerVoService.start(new String[]{taskSchedulerVo.getTaskCode()});
        });
        return quantifyTasks;
    }

    private List<QuantifyTask> buildQuantifyTask(AgreementVo agreementVo, QuantifyConfiguration quantifyConfiguration) {
        List terminalVos = this.terminalVoService.findByTerminalCodes((List)Lists.newArrayList((Object[])new String[]{agreementVo.getTerminalCode()}));
        ArrayList quantifyTaskList = Lists.newArrayList();
        Map<String, List<QuantifyExpression>> quantifyExpressMap = this.convertMapByCalculateCycle(quantifyConfiguration);
        if (quantifyExpressMap.size() == 0) {
            return quantifyTaskList;
        }
        AgreementLadderVo agreementLadderVo = this.agreementLadderVoService.findByLadderCode(quantifyConfiguration.getAgreementLadderCode());
        if (Objects.isNull(agreementLadderVo)) {
            return quantifyTaskList;
        }
        quantifyExpressMap.forEach((key, value) -> {
            QuantifyTaskBuilder taskBuilder = this.findBuilderByCalculateCycle((String)key);
            if (Objects.isNull(taskBuilder)) {
                return;
            }
            List<QuantifyTask> quantifyTasks = taskBuilder.assemblyQuantifyTask(agreementVo, agreementLadderVo);
            if (CollectionUtils.isEmpty(quantifyTasks)) {
                return;
            }
            List businessCodes = this.generateCodeService.generateCode("quantify_task_code", quantifyTasks.size());
            Validate.isTrue((!CollectionUtils.isEmpty((Collection)businessCodes) && businessCodes.size() == quantifyTasks.size() ? 1 : 0) != 0, (String)"\u751f\u6210\u4e1a\u52a1\u5355\u53f7\u5f02\u5e38", (Object[])new Object[0]);
            for (int i = 0; i < quantifyTasks.size(); ++i) {
                QuantifyTask task = quantifyTasks.get(i);
                task.setBusinessCode((String)businessCodes.get(i));
                task.setQuantifyPolicyId(quantifyConfiguration.getQuantifyPolicyId());
                task.setTaskType((String)key);
                task.setAgreementId(agreementVo.getAgreementCode());
                task.setAgreementName(agreementVo.getAgreementName());
                task.setTemplateId(agreementVo.getTemplateCode());
                task.setTemplateName(agreementVo.getBelongTemplate());
                task.setTerminalCode(agreementVo.getTerminalCode());
                task.setTerminalName(agreementVo.getRelationTerminal());
                if (CollectionUtils.isEmpty((Collection)terminalVos)) {
                    TerminalVo vo = (TerminalVo)terminalVos.get(0);
                    task.setTerminalClassify(vo.getTerminalClassify());
                    task.setDistribution(vo.getProvinceName() + "/" + vo.getCityName() + "/" + vo.getDistrictName());
                }
                task.setQuantifyPolicyConfigurationId(quantifyConfiguration.getId());
                task.setTenantCode(TenantUtils.getTenantCode());
                task.setOnlyHighestLevel(quantifyConfiguration.getOnlyHighestLevel());
                task.setQuantifyTaskExpressions((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)value, QuantifyExpression.class, QuantifyTaskExpression.class, HashSet.class, ArrayList.class, new String[0]));
                task.getQuantifyTaskExpressions().forEach(quantifyExpress -> {
                    quantifyExpress.setBusinessCode(task.getBusinessCode());
                    quantifyExpress.setId(null);
                });
                quantifyTaskList.add(task);
            }
        });
        return quantifyTaskList;
    }

    private Map<String, List<QuantifyExpression>> convertMapByCalculateCycle(QuantifyConfiguration quantifyConfiguration) {
        HashMap quantifyExpressionMap = Maps.newHashMap();
        quantifyConfiguration.getQuantifyExpressions().forEach(quantifyExpression -> {
            List expressions = (List)quantifyExpressionMap.get(quantifyExpression.getCalculateCycle());
            if (CollectionUtils.isEmpty((Collection)expressions)) {
                expressions = Lists.newArrayList();
            }
            expressions.add(quantifyExpression);
            quantifyExpressionMap.put(quantifyExpression.getCalculateCycle(), expressions);
        });
        return quantifyExpressionMap;
    }

    private QuantifyTaskBuilder findBuilderByCalculateCycle(String calculateCycle) {
        QuantifyTaskBuilder quantifyTaskBuilder = null;
        for (QuantifyTaskBuilder t : this.quantifyTaskBuilderList) {
            if (!t.quantifyTaskCycle().equals(calculateCycle)) continue;
            quantifyTaskBuilder = t;
            break;
        }
        return quantifyTaskBuilder;
    }

    @Override
    public QuantifyTask findById(String id) {
        return (QuantifyTask)((Object)this.quantifyTaskRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public List<QuantifyTask> findByConditions(Pageable pageable, QuantifyTaskDto quantifyTaskDto) {
        return this.quantifyTaskRepository.findByConditions(pageable, quantifyTaskDto);
    }

    @Override
    @Transactional
    public void triggerQuantityTask(String businessCode) {
        QuantifyTask quantifyTask = this.quantifyTaskRepository.findByBusinessCode(businessCode);
        Validate.notNull((Object)((Object)quantifyTask), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u5305\u91cf\u4efb\u52a1\uff01"), (Object[])new Object[0]);
        Validate.isTrue((boolean)quantifyTask.getTaskStatus().equals(QuantifyTaskStatusEnum.STATUS_DOING.getCode()), (String)"\u53ea\u6709\u5904\u4e8e\u6267\u884c\u4e2d\u4efb\u52a1\u53ef\u4ee5\u8fdb\u884c\u7ed3\u7b97", (Object[])new Object[0]);
        QuantifyPolicy policy = this.quantifyPolicyService.findByTemplateCode(quantifyTask.getTemplateId());
        Validate.notNull((Object)((Object)policy), (String)("\u4e1a\u52a1\u5355\u53f7\uff1a" + businessCode + "\u672a\u83b7\u53d6\u5230\u5bf9\u5e94\u5305\u91cf\u653f\u7b56\uff01"), (Object[])new Object[0]);
        List<QuantifyTaskDetail> quantifyTaskDetails = this.buildTaskDetail(policy, quantifyTask);
        this.sendToCost(quantifyTask, quantifyTaskDetails);
        this.updateQuantifyTask(quantifyTask, quantifyTaskDetails);
        this.quantifyTaskDetailRepository.saveBatch(quantifyTaskDetails);
    }

    private List<QuantifyTaskDetail> buildTaskDetail(QuantifyPolicy policy, QuantifyTask quantifyTask) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        policy.getQuantifyConfigurations().forEach(configuration -> {
            if (!quantifyTask.getQuantifyPolicyConfigurationId().equals(configuration.getId())) {
                return;
            }
            int scanCount = 0;
            ScanCodeRecordStatisticsDto scanCodeRecordStatisticsDto = new ScanCodeRecordStatisticsDto();
            scanCodeRecordStatisticsDto.setCreateTimeStart(quantifyTask.getTaskStartTime());
            scanCodeRecordStatisticsDto.setCreateTimeEnd(quantifyTask.getTaskEndTime());
            scanCodeRecordStatisticsDto.setScanParticipatorCode(quantifyTask.getTerminalCode());
            if ("DIMENSION_ALL".equals(policy.getDimensionFlag())) {
                scanCodeRecordStatisticsDto.setMaterialCodes((List)Lists.newArrayList());
                scanCount = this.scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
            } else {
                List dimensionCodes = configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList());
                List materialCodes = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(dimensionCodes, policy.getDimensionFlag());
                if (!CollectionUtils.isEmpty((Collection)materialCodes)) {
                    scanCodeRecordStatisticsDto.setMaterialCodes(materialCodes);
                    scanCount = this.scanCodeRecordVoService.countByScanCodeRecordDto(scanCodeRecordStatisticsDto);
                }
            }
            BigDecimal reachRate = new BigDecimal(scanCount).divide(quantifyTask.getSaleTarget(), 4, RoundingMode.HALF_UP).multiply(new BigDecimal(100));
            if (quantifyTask.getOnlyHighestLevel().equals(AutoSignEnum.YES.getCode())) {
                quantifyTaskDetails.addAll(this.calculateWithOnlyHighestLevel(quantifyTask, new BigDecimal(scanCount), reachRate));
            } else {
                quantifyTaskDetails.addAll(this.calculateWithAllLevel(quantifyTask, new BigDecimal(scanCount), reachRate));
            }
        });
        return quantifyTaskDetails;
    }

    private void sendToCost(QuantifyTask quantifyTask, List<QuantifyTaskDetail> quantifyTaskDetails) {
        if (CollectionUtils.isEmpty(quantifyTaskDetails)) {
            return;
        }
        ArrayList policyRewardConditionDtos = Lists.newArrayList();
        quantifyTaskDetails.forEach(detail -> {
            if (AutoSignEnum.YES.getCode().equals(detail.getProfitStatus())) {
                PolicyRewardConditionDto policyRewardConditionDto = new PolicyRewardConditionDto();
                policyRewardConditionDto.setPolicyName(this.quantifyPolicyMountRegister.getName());
                policyRewardConditionDto.setActualParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
                policyRewardConditionDto.setActualParticipatorCode(quantifyTask.getTerminalCode());
                policyRewardConditionDto.setParticipatorFlag(ParticipatorTypeEnum.TERMINAL.getDictCode());
                policyRewardConditionDto.setParticipatorName(ParticipatorTypeEnum.TERMINAL.getValue());
                policyRewardConditionDto.setTemplateCode(quantifyTask.getTemplateId());
                policyRewardConditionDto.setRewardMethodFlag(detail.getRewardMethodFlag());
                policyRewardConditionDto.setRewardMethodName(detail.getRewardMethodName());
                policyRewardConditionDto.setAwardConditionFlag(detail.getAwardConditionFlag());
                policyRewardConditionDto.setAwardConditionName(detail.getAwardConditionName());
                policyRewardConditionDto.setRewardData(detail.getRewardData().toString());
                policyRewardConditionDto.setTriggerAction("quantify");
                policyRewardConditionDto.setTriggerObject(quantifyTask.getBusinessCode());
                policyRewardConditionDto.setAgreementCode(quantifyTask.getAgreementId());
                policyRewardConditionDto.setGiftCode(detail.getGiftCode());
                policyRewardConditionDtos.add(policyRewardConditionDto);
            }
        });
        if (!CollectionUtils.isEmpty((Collection)policyRewardConditionDtos) && !CollectionUtils.isEmpty(this.policyRewardServiceObservers)) {
            this.policyRewardServiceObservers.forEach(policyRewardServiceObserver -> policyRewardServiceObserver.createRewardRecord(policyRewardConditionDtos));
        }
    }

    private void updateQuantifyTask(QuantifyTask quantifyTask, List<QuantifyTaskDetail> quantifyTaskDetails) {
        if (CollectionUtils.isEmpty(quantifyTaskDetails)) {
            quantifyTask.setReachRate(BigDecimal.ZERO);
            quantifyTask.setTaskStatus(QuantifyTaskStatusEnum.STATUS_EXPIRED.getCode());
        }
        BigDecimal reachRate = BigDecimal.ZERO;
        String taskStatus = QuantifyTaskStatusEnum.STATUS_EXPIRED.getCode();
        for (QuantifyTaskDetail detail : quantifyTaskDetails) {
            reachRate = reachRate.add(detail.getReachRate());
            if (!detail.getProfitStatus().equals(AutoSignEnum.YES.getCode())) continue;
            taskStatus = QuantifyTaskStatusEnum.STATUS_COMPLETE.getCode();
        }
        quantifyTask.setReachRate(reachRate.divide(new BigDecimal(quantifyTaskDetails.size()), 4, RoundingMode.HALF_UP));
        quantifyTask.setTaskStatus(taskStatus);
        this.quantifyTaskRepository.updateById((Object)quantifyTask);
    }

    @Override
    @DynamicTaskService(cornExpression="1 0 0 * * ?", taskDesc="\u6bcf\u65e5\u66f4\u65b0\u5f85\u6267\u884c\u4efb\u52a1\u72b6\u6001")
    public void updateQuantifyTaskStatus() {
        List<QuantifyTask> quantifyTasks = this.quantifyTaskRepository.findByAgreementIdAndStatus(null, QuantifyTaskStatusEnum.STATUS_WAIT.getCode(), new Date());
        if (!CollectionUtils.isEmpty(quantifyTasks)) {
            quantifyTasks.forEach(quantifyTask -> quantifyTask.setTaskStatus(QuantifyTaskStatusEnum.STATUS_DOING.getCode()));
            this.quantifyTaskRepository.saveOrUpdateBatch(quantifyTasks);
        }
    }

    private List<QuantifyTaskDetail> calculateWithOnlyHighestLevel(QuantifyTask quantifyTask, BigDecimal scanCount, BigDecimal reachRate) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        if (CollectionUtils.isEmpty(quantifyTask.getQuantifyTaskExpressions())) {
            return quantifyTaskDetails;
        }
        quantifyTask.getQuantifyTaskExpressions().sort((o1, o2) -> o2.getReachRate().compareTo(o1.getReachRate()));
        BigDecimal alreadyReachRate = null;
        for (QuantifyTaskExpression expression : quantifyTask.getQuantifyTaskExpressions()) {
            QuantifyTaskDetail quantifyTaskDetail = (QuantifyTaskDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expression, QuantifyTaskDetail.class, Set.class, ArrayList.class, new String[0]));
            quantifyTaskDetail.setId(null);
            quantifyTaskDetail.setBusinessCode(quantifyTask.getBusinessCode());
            quantifyTaskDetail.setSaleTarget(quantifyTask.getSaleTarget());
            quantifyTaskDetail.setActualSales(scanCount);
            quantifyTaskDetail.setReachRate(reachRate);
            if (!Objects.isNull(alreadyReachRate)) {
                if (alreadyReachRate.compareTo(expression.getReachRate()) == 0) {
                    quantifyTaskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
                } else {
                    quantifyTaskDetail.setProfitStatus(AutoSignEnum.NO.getCode());
                }
            } else {
                quantifyTaskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
                alreadyReachRate = quantifyTaskDetail.getProfitStatus().equals(AutoSignEnum.YES.getCode()) ? expression.getReachRate() : null;
            }
            quantifyTaskDetails.add(quantifyTaskDetail);
        }
        return quantifyTaskDetails;
    }

    private List<QuantifyTaskDetail> calculateWithAllLevel(QuantifyTask quantifyTask, BigDecimal scanCount, BigDecimal reachRate) {
        ArrayList quantifyTaskDetails = Lists.newArrayList();
        if (CollectionUtils.isEmpty(quantifyTask.getQuantifyTaskExpressions())) {
            return quantifyTaskDetails;
        }
        for (QuantifyTaskExpression expression : quantifyTask.getQuantifyTaskExpressions()) {
            QuantifyTaskDetail quantifyTaskDetail = (QuantifyTaskDetail)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)expression, QuantifyTaskDetail.class, Set.class, ArrayList.class, new String[0]));
            quantifyTaskDetail.setId(null);
            quantifyTaskDetail.setBusinessCode(quantifyTask.getBusinessCode());
            quantifyTaskDetail.setSaleTarget(quantifyTask.getSaleTarget());
            quantifyTaskDetail.setActualSales(scanCount);
            quantifyTaskDetail.setReachRate(reachRate);
            quantifyTaskDetail.setProfitStatus(reachRate.compareTo(expression.getReachRate()) > -1 ? AutoSignEnum.YES.getCode() : AutoSignEnum.NO.getCode());
            quantifyTaskDetails.add(quantifyTaskDetail);
        }
        return quantifyTaskDetails;
    }
}

