/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.utils;

import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import java.math.BigDecimal;

public class QuantifyUtils {
    public static BigDecimal getScaleByMonth(int month, AgreementLadderVo agreementLadderVo) {
        switch (month) {
            case 1: {
                return agreementLadderVo.getJanuarySaleNum();
            }
            case 2: {
                return agreementLadderVo.getFebruarySaleNum();
            }
            case 3: {
                return agreementLadderVo.getMarchSaleNum();
            }
            case 4: {
                return agreementLadderVo.getAprilSaleNum();
            }
            case 5: {
                return agreementLadderVo.getMaySaleNum();
            }
            case 6: {
                return agreementLadderVo.getJuneSaleNum();
            }
            case 7: {
                return agreementLadderVo.getJulySaleNum();
            }
            case 8: {
                return agreementLadderVo.getAugustSaleNum();
            }
            case 9: {
                return agreementLadderVo.getSeptemberSaleNum();
            }
            case 10: {
                return agreementLadderVo.getOctoberSaleNum();
            }
            case 11: {
                return agreementLadderVo.getNovemberSaleNum();
            }
        }
        return agreementLadderVo.getDecemberSaleNum();
    }

    public static BigDecimal getScaleBySeason(int month, AgreementLadderVo agreementLadderVo) {
        int seasonMonths = 3 % month;
        switch (seasonMonths) {
            case 0: {
                return QuantifyUtils.getScaleByMonth(month, agreementLadderVo);
            }
            case 1: {
                return QuantifyUtils.getScaleByMonth(month, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(month + 1, agreementLadderVo));
            }
        }
        return QuantifyUtils.getScaleByMonth(month, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(month + 1, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(month + 2, agreementLadderVo)));
    }

    public static BigDecimal getScaleByHalfYear(int month, AgreementLadderVo agreementLadderVo) {
        int season = month / 3 + 1;
        switch (season) {
            case 1: {
                return QuantifyUtils.getScaleBySeason(month, agreementLadderVo).add(QuantifyUtils.getScaleBySeason(4, agreementLadderVo));
            }
            case 3: {
                return QuantifyUtils.getScaleBySeason(month, agreementLadderVo).add(QuantifyUtils.getScaleBySeason(10, agreementLadderVo));
            }
        }
        return QuantifyUtils.getScaleBySeason(month, agreementLadderVo);
    }

    public static BigDecimal getScaleByYear(int month, AgreementLadderVo agreementLadderVo) {
        int halfYear = month / 6;
        switch (halfYear) {
            case 0: {
                return QuantifyUtils.getScaleByHalfYear(month, agreementLadderVo).add(QuantifyUtils.getScaleBySeason(7, agreementLadderVo));
            }
        }
        return QuantifyUtils.getScaleBySeason(month, agreementLadderVo);
    }
}

