/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyInfoServiceObserver;
import com.biz.crm.cps.business.agreement.sdk.vo.TemplatePolicyRelationshipVo;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyExpression;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyExpressionRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyPolicyRepository;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgreementQuantifyInfoServiceObserverImpl
implements AgreementPolicyInfoServiceObserver {
    private static final Logger log = LoggerFactory.getLogger(AgreementQuantifyInfoServiceObserverImpl.class);
    @Autowired
    private QuantifyExpressionRepository quantifyExpressionRepository;
    @Autowired
    private QuantifyPolicyRepository quantifyPolicyRepository;
    @Autowired
    private MaterialVoService materialVoService;

    public BigDecimal findNum(List<String> agreementIds, String calculateCycle, String rewardMethodFlag) {
        return this.quantifyExpressionRepository.findRewardData(agreementIds, calculateCycle, rewardMethodFlag);
    }

    public TemplatePolicyRelationshipVo findPolicyInfoByTemplateCode(String templateCode) {
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyRepository.findDetailByTemplateCode(templateCode);
        if (Objects.nonNull((Object)quantifyPolicy)) {
            Set<QuantifyRange> ranges;
            log.info("quantifyPolicy ==={}", (Object)JSONObject.toJSONString((Object)((Object)quantifyPolicy)));
            TemplatePolicyRelationshipVo vo = new TemplatePolicyRelationshipVo();
            vo.setTemplateCode(templateCode);
            vo.setPolicyLadderCode(quantifyPolicy.getQuantifyConfigurations().iterator().next().getAgreementLadderCode());
            Set<QuantifyExpression> expressions = quantifyPolicy.getQuantifyConfigurations().iterator().next().getQuantifyExpressions();
            if (CollectionUtils.isNotEmpty(expressions)) {
                for (QuantifyExpression expression : expressions) {
                    if (!"gift".equals(expression.getRewardMethodFlag())) continue;
                    vo.setGiftCode(expression.getGiftCode());
                }
            }
            if (!CollectionUtils.isNotEmpty(ranges = quantifyPolicy.getQuantifyConfigurations().iterator().next().getQuantifyRanges())) {
                ArrayList materialGroupCodes = Lists.newArrayList();
                for (QuantifyRange range : ranges) {
                    materialGroupCodes.add(range.getSpecialCode());
                }
                List materialProductCodes = this.materialVoService.findMaterialProductCodesByDimensionCodesAndDimensionType((List)materialGroupCodes, quantifyPolicy.getDimensionFlag());
                vo.setMaterialProductCode(materialProductCodes);
            }
            return vo;
        }
        return null;
    }
}

