/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementRelationActivityVoService;
import com.biz.crm.cps.business.common.sdk.enums.SendEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.sdk.vo.LoginUserDetails;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.ladder.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyPolicyRepository;
import com.biz.crm.cps.business.policy.quantify.ladder.repository.QuantifyTaskRepository;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.biz.crm.cps.business.product.sdk.vo.MaterialVo;
import com.biz.crm.cps.business.reward.gift.sdk.service.observer.RewardGiftPolicyObserver;
import com.biz.crm.cps.external.feign.service.CpsSfaFeign;
import com.biz.crm.nebular.sfa.activity.req.CpsActivityItemQueryReqVo;
import com.biz.crm.nebular.sfa.activity.req.CpsPackageFeeCreateReqVo;
import com.biz.crm.nebular.sfa.activity.req.PackageFeeProductVo;
import com.biz.crm.nebular.sfa.activity.resp.CpsActivityItemQueryRespVo;
import com.biz.crm.util.Result;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class QuantifyPolicyObserverImpl
implements RewardGiftPolicyObserver {
    private static final Logger log = LoggerFactory.getLogger(QuantifyPolicyObserverImpl.class);
    @Autowired
    private CpsSfaFeign cpsSfaFeign;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private QuantifyTaskRepository quantifyTaskRepository;
    @Autowired
    private QuantifyPolicyRepository quantifyPolicyRepository;
    @Autowired
    private AgreementRelationActivityVoService agreementRelationActivityVoService;

    public void sendToSfa(String business, BigDecimal amount, String address, List<String> imgs) {
        log.info("\u5305\u91cf\u8d44\u6e90\u63a8\u9001SFA-business={},amount={}", (Object)business, (Object)amount);
        LoginUserDetails loginUserDetails = this.loginUserService.getLoginUser();
        if (Objects.isNull(loginUserDetails)) {
            return;
        }
        QuantifyTask quantifyTask = this.quantifyTaskRepository.findByBusinessCode(business);
        if (Objects.isNull((Object)quantifyTask)) {
            return;
        }
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyRepository.findDetailById(quantifyTask.getQuantifyPolicyId());
        List actCodes = this.agreementRelationActivityVoService.findActCodesByAgreementId(quantifyTask.getAgreementId());
        if (!CollectionUtils.isEmpty((Collection)actCodes)) {
            for (String actCode : actCodes) {
                CpsActivityItemQueryReqVo dto = new CpsActivityItemQueryReqVo();
                dto.setActivityItemCode(actCode);
                Result actResult = this.cpsSfaFeign.cpsActivityItemQuery(dto);
                if (!Objects.nonNull(actResult) || !actResult.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)actResult.getResult()))) continue;
                CpsActivityItemQueryRespVo act = (CpsActivityItemQueryRespVo)((List)actResult.getResult()).get(0);
                if (!quantifyTask.getCreateTime().before(act.getEndTime()) || !quantifyTask.getCreateTime().after(act.getEndTime())) continue;
                CpsPackageFeeCreateReqVo req = new CpsPackageFeeCreateReqVo();
                req.setActivityItemCode(actCode);
                req.setUserCode(loginUserDetails.getAccount());
                req.setUserName(this.loginUserService.getLoginAccountName());
                req.setUserPosCode(loginUserDetails.getPostCode());
                req.setUserPosName(loginUserDetails.getPostName());
                req.setExecuteAddress(address);
                req.setObjectCode(quantifyTask.getTerminalCode());
                req.setObjectName(quantifyTask.getTerminalName());
                req.setStartTime(act.getStartTime());
                req.setEndTime(act.getEndTime());
                req.setTargetTaskAmount(quantifyTask.getSaleTarget());
                if (Objects.nonNull(amount) && amount.compareTo(new BigDecimal(0)) == 1) {
                    req.setPackageFeeAmount(amount.multiply(act.getHonourProductPrice()));
                } else {
                    req.setPackageFeeAmount(new BigDecimal(0));
                }
                ArrayList specialCodes = Lists.newArrayList();
                for (QuantifyRange range : quantifyPolicy.getQuantifyConfigurations().iterator().next().getQuantifyRanges()) {
                    specialCodes.add(range.getSpecialCode());
                }
                List materialVos = this.materialVoService.findMaterialDimensionCodesAndDimensionType((List)specialCodes, quantifyPolicy.getDimensionFlag());
                ArrayList products = Lists.newArrayList();
                if (!CollectionUtils.isEmpty((Collection)materialVos)) {
                    for (MaterialVo materialVo : materialVos) {
                        PackageFeeProductVo productVo = new PackageFeeProductVo();
                        productVo.setProductCode(materialVo.getMaterialCode());
                        productVo.setProductName(materialVo.getMaterialName());
                        products.add(productVo);
                    }
                }
                req.setProducts((List)products);
                log.info("\u5305\u91cf\u8d44\u6e90\u63a8\u9001SFA\u5165\u53c2={}", (Object)JSONObject.toJSONString((Object)req));
                Result result = this.cpsSfaFeign.cpsCreatePackageFee(req);
                log.info("\u5305\u91cf\u8d44\u6e90\u63a8\u9001SFA\u8fd4\u56de={}", (Object)JSONObject.toJSONString((Object)result));
                if (!Objects.nonNull(result) || !result.isSuccess()) continue;
                quantifyTask.setSendSfa(SendEnum.YES.getCode());
                this.quantifyTaskRepository.updateById((Object)quantifyTask);
            }
        }
    }
}

