/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.ladder.utils;

import com.biz.crm.cps.business.agreement.sdk.vo.AgreementLadderVo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuantifyUtils {
    private static final Logger log = LoggerFactory.getLogger(QuantifyUtils.class);

    public static BigDecimal getScaleByMonth(int month, AgreementLadderVo agreementLadderVo) {
        switch (month) {
            case 1: {
                return agreementLadderVo.getJanuarySaleNum();
            }
            case 2: {
                return agreementLadderVo.getFebruarySaleNum();
            }
            case 3: {
                return agreementLadderVo.getMarchSaleNum();
            }
            case 4: {
                return agreementLadderVo.getAprilSaleNum();
            }
            case 5: {
                return agreementLadderVo.getMaySaleNum();
            }
            case 6: {
                return agreementLadderVo.getJuneSaleNum();
            }
            case 7: {
                return agreementLadderVo.getJulySaleNum();
            }
            case 8: {
                return agreementLadderVo.getAugustSaleNum();
            }
            case 9: {
                return agreementLadderVo.getSeptemberSaleNum();
            }
            case 10: {
                return agreementLadderVo.getOctoberSaleNum();
            }
            case 11: {
                return agreementLadderVo.getNovemberSaleNum();
            }
        }
        return agreementLadderVo.getDecemberSaleNum();
    }

    public static BigDecimal getScaleBySeason(int month, AgreementLadderVo agreementLadderVo) {
        if (month >= 1 && month <= 3) {
            return QuantifyUtils.getScaleByMonth(1, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(2, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(3, agreementLadderVo)));
        }
        if (month >= 4 && month <= 6) {
            return QuantifyUtils.getScaleByMonth(4, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(5, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(6, agreementLadderVo)));
        }
        if (month >= 7 && month <= 9) {
            return QuantifyUtils.getScaleByMonth(7, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(8, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(9, agreementLadderVo)));
        }
        if (month >= 10 && month <= 12) {
            return QuantifyUtils.getScaleByMonth(10, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(11, agreementLadderVo).add(QuantifyUtils.getScaleByMonth(12, agreementLadderVo)));
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getScaleByHalfYear(int month, AgreementLadderVo agreementLadderVo) {
        int season = month / 3 + 1;
        switch (season) {
            case 1: {
                return QuantifyUtils.getScaleBySeason(month, agreementLadderVo).add(QuantifyUtils.getScaleBySeason(4, agreementLadderVo));
            }
            case 3: {
                return QuantifyUtils.getScaleBySeason(month, agreementLadderVo).add(QuantifyUtils.getScaleBySeason(10, agreementLadderVo));
            }
        }
        return QuantifyUtils.getScaleBySeason(month, agreementLadderVo);
    }

    public static BigDecimal getScaleByYear(int month, AgreementLadderVo agreementLadderVo) {
        int halfYear = month / 6;
        switch (halfYear) {
            case 0: {
                return QuantifyUtils.getScaleByHalfYear(month, agreementLadderVo).add(QuantifyUtils.getScaleBySeason(7, agreementLadderVo));
            }
        }
        return QuantifyUtils.getScaleBySeason(month, agreementLadderVo);
    }

    public static String[] getCurrQuarter(int num) {
        String[] s = new String[2];
        String str = "";
        Calendar quarterCalendar = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        switch (num) {
            case 1: {
                quarterCalendar = Calendar.getInstance();
                quarterCalendar.set(2, 3);
                quarterCalendar.set(5, 1);
                quarterCalendar.add(5, -1);
                str = simpleDateFormat.format(quarterCalendar.getTime());
                s[0] = str.substring(0, str.length() - 5) + "01-01";
                s[1] = str;
                break;
            }
            case 2: {
                quarterCalendar = Calendar.getInstance();
                quarterCalendar.set(2, 6);
                quarterCalendar.set(5, 1);
                quarterCalendar.add(5, -1);
                str = simpleDateFormat.format(quarterCalendar.getTime());
                s[0] = str.substring(0, str.length() - 5) + "04-01";
                s[1] = str;
                break;
            }
            case 3: {
                quarterCalendar = Calendar.getInstance();
                quarterCalendar.set(2, 9);
                quarterCalendar.set(5, 1);
                quarterCalendar.add(5, -1);
                str = simpleDateFormat.format(quarterCalendar.getTime());
                s[0] = str.substring(0, str.length() - 5) + "07-01";
                s[1] = str;
                break;
            }
            case 4: {
                quarterCalendar = Calendar.getInstance();
                str = simpleDateFormat.format(quarterCalendar.getTime());
                s[0] = str.substring(0, str.length() - 5) + "10-01";
                s[1] = str.substring(0, str.length() - 5) + "12-31";
            }
        }
        return s;
    }

    public static Date getQurterStartTime() {
        String[] arry = QuantifyUtils.getCurrQuarter(QuantifyUtils.getQuarter());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return simpleDateFormat.parse(arry[0]);
        }
        catch (ParseException e) {
            log.error("praseTime error", (Throwable)e);
            return null;
        }
    }

    public static Date getQurterEndTime() {
        String[] arry = QuantifyUtils.getCurrQuarter(QuantifyUtils.getQuarter());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return simpleDateFormat.parse(arry[1]);
        }
        catch (ParseException e) {
            log.error("praseTime error", (Throwable)e);
            return null;
        }
    }

    public static Integer getQuarter() {
        Calendar c = Calendar.getInstance();
        int month = c.get(2) + 1;
        int quarter = 0;
        quarter = month >= 1 && month <= 3 ? 1 : (month >= 4 && month <= 6 ? 2 : (month >= 7 && month <= 9 ? 3 : 4));
        return quarter;
    }

    public static BigDecimal getScaleByTimeInterval(Date startTime, Date endTime, AgreementLadderVo agreementLadderVo) {
        BigDecimal target = BigDecimal.ZERO;
        while (startTime.before(endTime)) {
            target = target.add(QuantifyUtils.getScaleByMonth(startTime.getMonth() + 1, agreementLadderVo));
            startTime = DateUtils.ceiling((Date)startTime, (int)2);
        }
        return target;
    }
}

