package com.biz.crm.cps.business.policy.quantify.local.controller;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyTaskDto;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyTaskService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/13 9:38
 */
@Slf4j
@RestController
@RequestMapping("/v1/quantify/task")
@Api(tags = "包量任务相关接口")
public class QuantifyTaskController {

  @Autowired
  private QuantifyTaskService quantifyTaskService;

  @ApiOperation(value = "创建包量任务")
  @PostMapping("")
  public Result<List<QuantifyTask>> create(@RequestBody String agreementId) {
    try {
      List<QuantifyTask> taskList = quantifyTaskService.create(agreementId);
      return Result.ok(taskList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "分页获取包量任务")
  @PostMapping("findByConditions")
  public Result<List<QuantifyTask>> findByConditions(@PageableDefault(50) Pageable pageable, @RequestBody QuantifyTaskDto quantifyTaskDto) {
    try {
      List<QuantifyTask> taskList = quantifyTaskService.findByConditions(pageable, quantifyTaskDto);
      return Result.ok(taskList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "手动结算包量任务")
  @GetMapping("summaryQuantityTask")
  public Result<?> summaryQuantityTask(@RequestParam("businessCode") String businessCode) {
    try {
      quantifyTaskService.triggerQuantityTask(businessCode);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
