package com.biz.crm.cps.business.policy.quantify.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021/8/7 16:46
 * 包量政策实体
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyPolicy", description = "包量政策实体")
@TableName("quantify_policy")
public class QuantifyPolicy extends TenantOpEntity {
  
  private static final long serialVersionUID = -4979482354738454714L;

  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  @Column(name = "template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 协议模板id '")
  private String templateCode;

  /**
   * 总销量（标箱）
   */
  @ApiModelProperty("总销量（标箱）")
  @TableField(value = "total_sale")
  @Column(name = "total_sale", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 总销量(标箱) '")
  private BigDecimal totalSale;

  /**
   * 一月份销量（标箱）
   */
  @ApiModelProperty("一月份销量（标箱）")
  @TableField(value = "january_sale_num")
  @Column(name = "january_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 一月份销量(标箱) '")
  private BigDecimal januarySaleNum;

  /**
   * 二月份销量（标箱）
   */
  @ApiModelProperty("二月份销量（标箱）")
  @TableField(value = "february_sale_num")
  @Column(name = "february_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 二月份销量(标箱) '")
  private BigDecimal februarySaleNum;

  /**
   * 三月份销量（标箱）
   */
  @ApiModelProperty("三月份销量（标箱）")
  @TableField(value = "march_sale_num")
  @Column(name = "march_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 三月份销量(标箱) '")
  private BigDecimal marchSaleNum;

  /**
   * 四月份销量（标箱）
   */
  @ApiModelProperty("四月份销量（标箱）")
  @TableField(value = "april_sale_num")
  @Column(name = "april_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 四月份销量(标箱) '")
  private BigDecimal aprilSaleNum;

  /**
   * 五月份销量（标箱）
   */
  @ApiModelProperty("五月份销量（标箱）")
  @TableField(value = "may_sale_num")
  @Column(name = "may_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 五月份销量(标箱) '")
  private BigDecimal maySaleNum;

  /**
   * 六月份销量（标箱）
   */
  @ApiModelProperty("六月份销量（标箱）")
  @TableField(value = "june_sale_num")
  @Column(name = "june_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 六月份销量(标箱) '")
  private BigDecimal juneSaleNum;

  /**
   * 七月份销量（标箱）
   */
  @ApiModelProperty("七月份销量（标箱）")
  @TableField(value = "july_sale_num")
  @Column(name = "july_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 七月份销量(标箱) '")
  private BigDecimal julySaleNum;

  /**
   * 八月份销量（标箱）
   */
  @ApiModelProperty("八月份销量（标箱）")
  @TableField(value = "august_sale_num")
  @Column(name = "august_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 八月份销量(标箱) '")
  private BigDecimal augustSaleNum;

  /**
   * 九月份销量（标箱）
   */
  @ApiModelProperty("九月份销量（标箱）")
  @TableField(value = "september_sale_num")
  @Column(name = "september_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 九月份销量(标箱) '")
  private BigDecimal septemberSaleNum;

  /**
   * 十月份销量（标箱）
   */
  @ApiModelProperty("十月份销量（标箱）")
  @TableField(value = "october_sale_num")
  @Column(name = "october_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十月份销量(标箱) '")
  private BigDecimal octoberSaleNum;

  /**
   * 十一月份销量（标箱）
   */
  @ApiModelProperty("十一月份销量（标箱）")
  @TableField(value = "november_sale_num")
  @Column(name = "november_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十一月份销量(标箱) '")
  private BigDecimal novemberSaleNum;

  /**
   * 十二月份销量（标箱）
   */
  @ApiModelProperty("十二月份销量（标箱）")
  @TableField(value = "december_sale_num")
  @Column(name = "december_sale_num", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 十二月份销量(标箱) '")
  private BigDecimal decemberSaleNum;

  /**
   * 包量达成计算周期(月,季度，半年，年)
   */
  @ApiModelProperty("包量达成计算周期(月,季度，半年，年)")
  @TableField(value = "calculate_cycle")
  @Column(name = "calculate_cycle", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 包量计算达成周期(月,季度，半年，年) '")
  private String calculateCycle;

  /**
   * 政策关联配置列表
   */
  @ApiModelProperty("政策关联配置列表")
  @TableField(exist = false)
  private Set<QuantifyConfiguration> quantifyConfigurations;
}
