package com.biz.crm.cps.business.policy.quantify.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.cps.business.common.local.entity.BaseIdEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;

/**
 * @author jerry7
 * @date 2021/8/7 16:07
 * 包量政策产品范围
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyRange", description = "包量政策的产品范围")
@TableName("quantify_range")
public class QuantifyRange extends BaseIdEntity {
  
  private static final long serialVersionUID = -2407183084982681605L;

  /**
   * 包量政策配置id
   */
  @ApiModelProperty("包量政策配置id")
  @TableField(value = "configuration_id")
  @Column(name = "configuration_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 包量政策id '")
  private String configurationId;

  /**
   * 产品维度编码(品牌编码，产品编码，类别编码等)
   */
  @ApiModelProperty("产品维度编码)")
  @TableField(value = "special_code")
  @Column(name = "special_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品维度编码 '")
  private String specialCode;

  /**
   * 产品维度名称(品牌名称，产品名称等)
   */
  @ApiModelProperty("产品维度名称")
  @TableField(value = "special_name")
  @Column(name = "special_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 产品维度名称 '")
  private String specialName;


}
