package com.biz.crm.cps.business.policy.quantify.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author jerry7
 * @date 2021/8/9 16:29
 * 包量任务实体
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyTask", description = "包量政策任务实体")
@TableName("quantify_task")
public class QuantifyTask extends TenantOpEntity {
  private static final long serialVersionUID = -779243171144160443L;

  /**
   * 业务单号(生成包量任务时生成)
   */
  @ApiModelProperty("业务单号")
  @TableField(value = "business_code")
  @Column(name = "business_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 业务单号 '")
  private String businessCode;

  /**
   * 包量政策id
   */
  @ApiModelProperty("包量政策id")
  @TableField(value = "quantify_policy_id")
  @Column(name = "quantify_policy_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 包量政策id '")
  private String quantifyPolicyId;
  /**
   * 所属协议id
   */
  @ApiModelProperty("所属协议id")
  @TableField(value = "agreement_id")
  @Column(name = "agreement_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属协议id '")
  private String agreementId;

  /**
   * 所属协议名称
   */
  @ApiModelProperty("所属协议名称")
  @TableField(value = "agreement_name")
  @Column(name = "agreement_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属协议名称 '")
  private String agreementName;

  /**
   * 所属模板id
   */
  @ApiModelProperty("所属模板id")
  @TableField(value = "template_id")
  @Column(name = "template_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属模板id '")
  private String templateId;

  /**
   * 所属模板名称
   */
  @ApiModelProperty("所属模板名称")
  @TableField(value = "template_name")
  @Column(name = "template_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 所属模板名称 '")
  private String templateName;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 终端编码 '")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  @TableField(value = "terminal_name")
  @Column(name = "terminal_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 终端名称 '")
  private String terminalName;

  /**
   * 销量目标
   */
  @ApiModelProperty("销量目标")
  @TableField(value = "sale_target")
  @Column(name = "sale_target", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 销量目标 '")
  private BigDecimal saleTarget;

  /**
   * 达成比例
   */
  @ApiModelProperty("达成比例")
  @TableField(value = "reach_rate")
  @Column(name = "reach_rate", precision = 20, scale = 4, columnDefinition = "DECIMAL(20,4) COMMENT ' 达成比例 '")
  private BigDecimal reachRate;

  /**
   * 任务名称(根据时间和协议，政策进行生成)
   */
  @ApiModelProperty("任务名称")
  @TableField(value = "task_name")
  @Column(name = "task_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务名称 '")
  private String taskName;

  /**
   * 任务类型(年度，半年度，季度，月度)
   */
  @ApiModelProperty("任务类型(年度，半年度，季度，月度)")
  @TableField(value = "task_type")
  @Column(name = "task_type", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务类型(年度，半年度，季度，月度) '")
  private String taskType;

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务开始时间")
  @TableField(value = "task_start_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "task_start_time", nullable = false, columnDefinition = "datetime COMMENT ' 任务开始时间 '")
  private Date taskStartTime;

  /**
   * 任务结束时间
   */
  @ApiModelProperty("任务结束时间")
  @TableField(value = "task_end_time")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss" )
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  @Column(name = "task_end_time", nullable = false, columnDefinition = "datetime COMMENT ' 任务结束时间 '")
  private Date taskEndTime;

  /**
   * 任务状态(未开始，进行中，已分利)
   */
  @ApiModelProperty("任务状态(未开始，进行中，已分利)")
  @TableField(value = "task_status")
  @Column(name = "task_status", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 任务状态(未开始，进行中，已分利) '")
  private String taskStatus;


}
