package com.biz.crm.cps.business.policy.quantify.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/9 19:02
 * 包量政策mapper
 */
public interface QuantifyPolicyMapper extends BaseMapper<QuantifyPolicy> {

  /**
   * 根据主键查询包量政策详情
   * @param id 主键
   * @return 包量政策详情
   */
  QuantifyPolicy findDetailsById(@Param("id") String id);

  /**
   * 根据主键查询包量政策详情
   * @param templateCode 模板编码
   * @return 包量政策详情
   */
  QuantifyPolicy findDetailsByTemplateCode(@Param("templateCode") String templateCode);

  /**
   * 条件查询
   * @param dto
   * @return
   */
  List<QuantifyPolicy> findByConditions(@Param("dto") QuantifyPolicyDto dto);
}
