package com.biz.crm.cps.business.policy.quantify.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyTaskDto;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.local.mapper.QuantifyTaskMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/12 19:59
 * 包量任务数据处理repository
 */
@Component
public class QuantifyTaskRepository extends ServiceImpl<QuantifyTaskMapper, QuantifyTask> {

  @Autowired
  private QuantifyTaskMapper quantifyTaskMapper;

  /**
   * 条件分页查询包量任务
   *
   * @param pageable        分页参数
   * @param quantifyTaskDto 请求参数
   * @return 包量任务实体
   */
  public List<QuantifyTask> findByConditions(Pageable pageable, QuantifyTaskDto quantifyTaskDto) {
    Page<QuantifyTask> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    return quantifyTaskMapper.findByConditions(page, quantifyTaskDto);
  }

  /**
   * 条件分页查询包量任务
   *
   * @param agreementId 协议ID
   * @param taskStatus  协议状态
   * @return 包量任务实体
   */
  public List<QuantifyTask> findByAgreementIdAndStatus(String agreementId, String taskStatus, Date startTime) {
    return quantifyTaskMapper.findByAgreementIdAndStatus(agreementId, taskStatus,startTime);
  }

  /**
   * 根据业务单号查询包量任务
   *
   * @return 包量任务实体
   */
  public QuantifyTask findByBusinessCode(String businessCode) {
    return quantifyTaskMapper.findByBusinessCode(businessCode);
  }
}
