package com.biz.crm.cps.business.policy.quantify.local.service;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyTaskDto;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyTask;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/9 18:57
 * 包量任务接口
 */
public interface QuantifyTaskService {

  /**
   * 创建包量任务
   * 当协议签署成功后，协议包含包量政策时即根据协议的生效时间和计算周期生成包量任务
   *
   * @param agreementId 协议id
   * @return 创建结果
   */
  List<QuantifyTask> create(String agreementId);

  /**
   * 创建包量任务
   * 当协议签署成功后，协议包含包量政策时即根据协议的生效时间和计算周期生成包量任务
   *
   * @param agreementVo 协议id
   * @return 创建结果
   */
  List<QuantifyTask> create(AgreementVo agreementVo);

  /**
   * 根据主键查询包量任务
   *
   * @param id 包量任务主键
   * @return 包量任务主体
   */
  QuantifyTask findById(String id);

  /**
   * 分页获取包量任务
   *
   * @param quantifyTaskDto 协议id
   * @return 创建结果
   */
  List<QuantifyTask> findByConditions(Pageable pageable, QuantifyTaskDto quantifyTaskDto);

  /**
   * 触发包量任务结算
   * @param businessCode 包量任务
   */
  void triggerQuantityTask(String businessCode);


  /**
   * 更新包量任务状态
   */
  void updateQuantifyTaskStatus();

}
