package com.biz.crm.cps.business.policy.quantify.local.service.builder;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyTaskStatusEnum;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementVo;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyTask;
import com.biz.crm.cps.business.policy.quantify.local.utils.QuantifyUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.time.DateUtils;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

/**
 * @author jerry7
 * @date 2021/8/25 15:09
 * 按半年度实现包量任务的组装
 */
public class QuantifyTaskHalfYearBuilder implements QuantifyTaskBuilder {

  @Override
  public List<QuantifyTask> assemblyQuantifyTask(AgreementVo agreementVo, QuantifyPolicy quantifyPolicy) {
    List<QuantifyTask> taskList = Lists.newArrayList();
    Date effectiveTime = agreementVo.getEffectiveStartTime();
    Date now = new Date();
    QuantifyTaskStatusEnum statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
    if (effectiveTime.before(now)) {
      effectiveTime = now;
      //当协议生效时间小于当前时间，即签署协议时协议已生效，则当前第一个任务为进行中，其余任务为待执行
      statusEnum = QuantifyTaskStatusEnum.STATUS_DOING;
    }
    while (effectiveTime.before(agreementVo.getEffectiveEndTime())) {
      Calendar calendar = Calendar.getInstance();
      calendar.setTime(effectiveTime);
      //获取当前月份
      int nowMonth = calendar.get(Calendar.MONTH) + 1;
      //获取当前年份
      int nowYear = calendar.get(Calendar.YEAR);
      //获取当前时间到下一个半年度结算点的月份
      int addMonths = nowMonth % 6;
      //构造包量任务
      QuantifyTask quantifyTask = new QuantifyTask();
      quantifyTask.setTaskStartTime(effectiveTime);
      quantifyTask.setTaskEndTime(DateUtils.addSeconds(DateUtils.addMonths(DateUtils.ceiling(effectiveTime, Calendar.MONTH), addMonths), -1));
      if (addMonths == 0) {
        //当前月份为当前半年度最后一个月，则下一个循环起点为下个月第一个时间点
        effectiveTime = DateUtils.ceiling(effectiveTime, Calendar.MONTH);
      } else {
        //当前月份不为当前半年度最后一个月，则下一个循环起点应补充到下一个半年度的第一个月份
        effectiveTime = DateUtils.addMonths(DateUtils.ceiling(effectiveTime, Calendar.MONTH), 6 - addMonths);
      }
      int halfYear = nowMonth / 6;
      if (halfYear == 1) {
        quantifyTask.setTaskName(nowYear + "年下半年包量任务");
      } else {
        quantifyTask.setTaskName(nowYear + "年上半年包量任务");
      }
      quantifyTask.setTaskStatus(statusEnum.getCode());
      quantifyTask.setSaleTarget(QuantifyUtils.getScaleByHalfYear(nowMonth, quantifyPolicy));
      taskList.add(quantifyTask);
      //同一个终端同一商品维度在同一时间段内只能存在一个包量任务，故生成包量任务后将后续任务状态置为待执行
      statusEnum = QuantifyTaskStatusEnum.STATUS_WAIT;
    }
    return taskList;
  }
}
