package com.biz.crm.cps.business.policy.quantify.local.service.observer;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyMountRegister;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementPolicyPojoObserver;
import com.bizunited.nebula.common.util.JsonUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

import java.util.Objects;

/**
 * 包量政策，用来处理协议模板与政策之间的对象转换
 * @author hefan
 */
@Component("QuantifyPolicyPojoObserverImpl")
public class QuantifyPolicyPojoObserverRegister implements AgreementPolicyPojoObserver {

  @Autowired
  @Qualifier("QuantifyPolicyMountRegisterImpl")
  private AgreementPolicyMountRegister agreementPolicyMountRegister;

  @Override
  public AgreementPolicyDto deserialize(JSONObject jsonObject) {
    /**
     * 把字符串转json对象
     * 获取跟扫码政策相关的信息
     * 将信息拷贝到对象中
     */
    if (Objects.isNull(jsonObject)) {
      return null;
    }
    return JsonUtils.json2Obj(jsonObject.toJSONString(), QuantifyPolicyDto.class);
  }

  @Override
  public JSONObject serialize(AgreementPolicyDto agreementPolicyDto) {
    return null;
  }
}
