package com.biz.crm.cps.business.policy.quantify.local.service.observer;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignEventDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignObserver;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyTaskService;

import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 包量政策，当协议签署时实现包量任务创建
 *
 * @author hefan
 */
@Component("quantifyPolicySignObserverImpl")
public class QuantifyPolicySignObserverImpl implements AgreementSignObserver {

  @Autowired
  private QuantifyTaskService quantifyTaskService;
  @Autowired
  private QuantifyPolicyService quantifyPolicyService;

  @Override
  public void onSuccess(AgreementSignEventDto dto) {
    QuantifyPolicy quantifyPolicy = quantifyPolicyService.findByTemplateCode(dto.getTemplateCode());
    if(Objects.nonNull(quantifyPolicy)){
      quantifyTaskService.create(dto.getAgreementCode());
    }
  }
}
