package com.biz.crm.cps.business.policy.quantify.local.utils;

import com.biz.crm.cps.bisiness.policy.quantify.sdk.constant.QuantifyConstant;
import org.apache.commons.lang3.StringUtils;

/**
 * @author jerry7
 * @date 2021/8/20 10:01
 * 公用的定时任务工具类
 */
public class SchedulerUtils  {

  /**
   * 每个自然月执行一次cron
   */
  public static final String CRON_MONTH = "0 0 0 1 1/1 ?";
  /**
   * 每3个自然月执行一次cron
   */
  public static final String CRON_SEASON = "0 0 0 1 1/3 ?";
  /**
   * 每6个自然月执行一次cron
   */
  public static final String CRON_HALF_YEAR = "0 0 0 1 1/6 ?";
  /**
   * 每个自然年执行一次cron
   */
  public static final String CRON_YEAR = "0 0 0 1 1 ? *";

  /**
   * 根据时间类别获取定时任务cron表达式
   *
   * @param dateType 时间类别(年/月/半年/季度)
   * @return cron表达式
   */
  public static String getSchedulerCron(String dateType) {
    if (StringUtils.isBlank(dateType)) {
      return CRON_MONTH;
    }
    switch (dateType) {
      case QuantifyConstant.YEAR:
        return CRON_YEAR;
      case QuantifyConstant.HALF_YEAR:
        return CRON_HALF_YEAR;
      case QuantifyConstant.SEASON:
        return CRON_SEASON;
      case QuantifyConstant.MONTH:
        //默认返回月度表达式
      default:
        return CRON_MONTH;
    }
  }
}
