/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.local.utils;

import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import java.math.BigDecimal;

public class QuantifyUtils {
    public static BigDecimal getScaleByMonth(int month, QuantifyPolicy quantifyPolicy) {
        switch (month) {
            case 1: {
                return quantifyPolicy.getJanuarySaleNum();
            }
            case 2: {
                return quantifyPolicy.getFebruarySaleNum();
            }
            case 3: {
                return quantifyPolicy.getMarchSaleNum();
            }
            case 4: {
                return quantifyPolicy.getAprilSaleNum();
            }
            case 5: {
                return quantifyPolicy.getMaySaleNum();
            }
            case 6: {
                return quantifyPolicy.getJuneSaleNum();
            }
            case 7: {
                return quantifyPolicy.getJulySaleNum();
            }
            case 8: {
                return quantifyPolicy.getAugustSaleNum();
            }
            case 9: {
                return quantifyPolicy.getSeptemberSaleNum();
            }
            case 10: {
                return quantifyPolicy.getOctoberSaleNum();
            }
            case 11: {
                return quantifyPolicy.getNovemberSaleNum();
            }
        }
        return quantifyPolicy.getDecemberSaleNum();
    }

    public static BigDecimal getScaleBySeason(int month, QuantifyPolicy quantifyPolicy) {
        int seasonMonths = 3 % month;
        switch (seasonMonths) {
            case 0: {
                return QuantifyUtils.getScaleByMonth(month, quantifyPolicy);
            }
            case 1: {
                return QuantifyUtils.getScaleByMonth(month, quantifyPolicy).add(QuantifyUtils.getScaleByMonth(month + 1, quantifyPolicy));
            }
        }
        return QuantifyUtils.getScaleByMonth(month, quantifyPolicy).add(QuantifyUtils.getScaleByMonth(month + 1, quantifyPolicy).add(QuantifyUtils.getScaleByMonth(month + 2, quantifyPolicy)));
    }

    public static BigDecimal getScaleByHalfYear(int month, QuantifyPolicy quantifyPolicy) {
        int season = month / 3 + 1;
        switch (season) {
            case 1: {
                return QuantifyUtils.getScaleBySeason(month, quantifyPolicy).add(QuantifyUtils.getScaleBySeason(4, quantifyPolicy));
            }
            case 3: {
                return QuantifyUtils.getScaleBySeason(month, quantifyPolicy).add(QuantifyUtils.getScaleBySeason(10, quantifyPolicy));
            }
        }
        return QuantifyUtils.getScaleBySeason(month, quantifyPolicy);
    }

    public static BigDecimal getScaleByYear(int month, QuantifyPolicy quantifyPolicy) {
        int halfYear = month / 6;
        switch (halfYear) {
            case 0: {
                return QuantifyUtils.getScaleByHalfYear(month, quantifyPolicy).add(QuantifyUtils.getScaleBySeason(7, quantifyPolicy));
            }
        }
        return QuantifyUtils.getScaleBySeason(month, quantifyPolicy);
    }
}

