/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.local.service.internal;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.biz.crm.cps.bisiness.policy.quantify.sdk.dto.QuantifyPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.biz.crm.cps.business.agreement.sdk.dto.ProfitAgreementTemplatePaginationDto;
import com.biz.crm.cps.business.agreement.sdk.dto.QuantifyRangeDto;
import com.biz.crm.cps.business.agreement.sdk.service.AgreementTemplateVoService;
import com.biz.crm.cps.business.agreement.sdk.vo.AgreementTemplateVo;
import com.biz.crm.cps.business.agreement.sdk.vo.TemplateOrgRelationshipVo;
import com.biz.crm.cps.business.common.sdk.enums.DimensionFlagEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyExpression;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicySign;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyRange;
import com.biz.crm.cps.business.policy.quantify.local.mapper.QuantifyConfigurationMapper;
import com.biz.crm.cps.business.policy.quantify.local.mapper.QuantifyExpressionMapper;
import com.biz.crm.cps.business.policy.quantify.local.mapper.QuantifyPolicyMapper;
import com.biz.crm.cps.business.policy.quantify.local.mapper.QuantifyPolicySignMapper;
import com.biz.crm.cps.business.policy.quantify.local.mapper.QuantifyRangeMapper;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyConfigurationRepository;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyExpressionRepository;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyPolicyRepository;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyPolicySignRepository;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyRangeRepository;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyPolicyService;
import com.biz.crm.cps.business.policy.quantify.local.service.observer.QuantifyPolicyMountRegisterImpl;
import com.biz.crm.cps.business.policy.quantify.local.service.observer.QuantifyPolicyPojoObserverRegister;
import com.biz.crm.cps.business.product.sdk.common.enums.MaterialDimensionEnum;
import com.biz.crm.cps.business.product.sdk.service.MaterialVoService;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class QuantifyPolicyServiceImpl
implements QuantifyPolicyService {
    @Autowired
    private QuantifyPolicyPojoObserverRegister policyPojoObserver;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private QuantifyPolicyRepository quantifyPolicyRepository;
    @Autowired
    private QuantifyConfigurationRepository quantifyConfigurationRepository;
    @Autowired
    private QuantifyRangeRepository quantifyRangeRepository;
    @Autowired
    private QuantifyExpressionRepository quantifyExpressionRepository;
    @Autowired
    private LoginUserService loginUserService;
    @Autowired
    private AgreementTemplateVoService agreementTemplateVoService;
    @Autowired
    @Qualifier(value="QuantifyPolicyMountRegisterImpl")
    private QuantifyPolicyMountRegisterImpl quantifyPolicyMountRegister;
    @Autowired
    private MaterialVoService materialVoService;
    @Autowired
    private QuantifyPolicySignRepository quantifyPolicySignRepository;

    @Override
    @Transactional
    public QuantifyPolicy create(AgreementPolicyDto agreementPolicyDto) {
        if (agreementPolicyDto == null) {
            return null;
        }
        QuantifyPolicy quantifyPolicy = (QuantifyPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementPolicyDto, QuantifyPolicy.class, HashSet.class, ArrayList.class, new String[]{"quantifyConfigurations", "quantifyConfigurations.quantifyRanges", "quantifyConfigurations.quantifyExpressions"}));
        return this.createFrom(quantifyPolicy);
    }

    @Override
    @Transactional
    public QuantifyPolicy createFrom(QuantifyPolicy quantifyPolicy) {
        this.createValidation(quantifyPolicy);
        Date now = new Date();
        quantifyPolicy.setCreateTime(now);
        quantifyPolicy.setModifyTime(now);
        quantifyPolicy.setCreateAccount(this.loginUserService.getLoginAccountName());
        quantifyPolicy.setModifyAccount(this.loginUserService.getLoginAccountName());
        this.quantifyPolicyRepository.save((Object)quantifyPolicy);
        quantifyPolicy.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            quantifyConfiguration.setQuantifyPolicyId(quantifyPolicy.getId());
            this.quantifyConfigurationRepository.save(quantifyConfiguration);
            quantifyConfiguration.getQuantifyExpressions().forEach(quantifyExpression -> quantifyExpression.setConfigurationId(quantifyConfiguration.getId()));
            this.quantifyExpressionRepository.saveBatch(quantifyConfiguration.getQuantifyExpressions());
            if (!"DIMENSION_ALL".equals(quantifyConfiguration.getDimensionFlag())) {
                quantifyConfiguration.getQuantifyRanges().forEach(quantifyRange -> quantifyRange.setConfigurationId(quantifyConfiguration.getId()));
                this.quantifyRangeRepository.saveBatch(quantifyConfiguration.getQuantifyRanges());
            }
        });
        return quantifyPolicy;
    }

    @Override
    public QuantifyPolicy findDetailByTemplateCode(String templateCode) {
        if (StringUtils.isBlank((CharSequence)templateCode)) {
            return null;
        }
        return this.quantifyPolicyRepository.findDetailByTemplateCode(templateCode);
    }

    @Override
    public QuantifyPolicy findById(String id) {
        return this.quantifyPolicyRepository.findDetailById(id);
    }

    @Override
    public QuantifyPolicy findByTemplateCode(String templateCode) {
        return this.quantifyPolicyRepository.findDetailByTemplateCode(templateCode);
    }

    private void createValidation(QuantifyPolicy entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        if (StringUtils.isBlank((CharSequence)entity.getTenantCode())) {
            entity.setTenantCode(TenantUtils.getTenantCode());
        }
        Validate.isTrue((!CollectionUtils.isEmpty(entity.getQuantifyConfigurations()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u914d\u7f6e\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getMinSale(), (String)"\u6700\u4f4e\u603b\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getMaxSale(), (String)"\u6700\u9ad8\u603b\u9500\u91cf\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((entity.getMaxSale().compareTo(entity.getMinSale()) >= 0 ? 1 : 0) != 0, (String)"\u6700\u9ad8\u603b\u9500\u91cf\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u6700\u4f4e\u603b\u9500\u91cf\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getJanuarySaleNum(), (String)"\u4e00\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getFebruarySaleNum(), (String)"\u4e8c\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getMarchSaleNum(), (String)"\u4e09\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getAprilSaleNum(), (String)"\u56db\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getMaySaleNum(), (String)"\u4e94\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getJuneSaleNum(), (String)"\u516d\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getJulySaleNum(), (String)"\u4e03\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getAugustSaleNum(), (String)"\u516b\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getSeptemberSaleNum(), (String)"\u4e5d\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getOctoberSaleNum(), (String)"\u5341\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getNovemberSaleNum(), (String)"\u5341\u4e00\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getDecemberSaleNum(), (String)"\u5341\u4e8c\u6708\u9500\u91cf\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal totalSaleNum = entity.getJanuarySaleNum().add(entity.getFebruarySaleNum()).add(entity.getMarchSaleNum()).add(entity.getAprilSaleNum()).add(entity.getMaySaleNum()).add(entity.getJuneSaleNum()).add(entity.getJulySaleNum()).add(entity.getAugustSaleNum()).add(entity.getSeptemberSaleNum()).add(entity.getOctoberSaleNum()).add(entity.getNovemberSaleNum()).add(entity.getDecemberSaleNum());
        Validate.isTrue((BigDecimal.valueOf(100L).compareTo(totalSaleNum) == 0 ? 1 : 0) != 0, (String)"\u6708\u9500\u91cf\u767e\u5206\u6bd4\u603b\u548c\u5fc5\u987b\u4e3a100", (Object[])new Object[0]);
        entity.getQuantifyConfigurations().forEach(quantifyConfiguration -> {
            Validate.notBlank((CharSequence)quantifyConfiguration.getDimensionFlag(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u6807\u8bb0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)quantifyConfiguration.getDimensionName(), (String)"\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            if (!"DIMENSION_ALL".equals(quantifyConfiguration.getDimensionFlag())) {
                Validate.isTrue((!CollectionUtils.isEmpty(quantifyConfiguration.getQuantifyRanges()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u4ea7\u54c1\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            }
            Validate.isTrue((!CollectionUtils.isEmpty(quantifyConfiguration.getQuantifyExpressions()) ? 1 : 0) != 0, (String)"\u653f\u7b56\u5173\u8054\u5206\u5229\u8868\u8fbe\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            quantifyConfiguration.getQuantifyRanges().forEach(this::quantifyRangeValidation);
            quantifyConfiguration.getQuantifyExpressions().forEach(this::quantifyExpressionValidation);
        });
    }

    private void quantifyExpressionValidation(QuantifyExpression entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getRewardMethodFlag(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u6807\u5fd7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getRewardMethodName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u65b9\u5f0f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getReachRate(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u9636\u68af\u8fbe\u6210\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getReachRate().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u9636\u68af\u8fbe\u6210\u6bd4\u4f8b\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)entity.getRewardData(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5956\u52b1\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((entity.getRewardData().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5956\u52b1\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\uff01", (Object[])new Object[0]);
    }

    private void quantifyRangeValidation(QuantifyRange entity) {
        Validate.notNull((Object)((Object)entity), (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)entity.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        entity.setId(null);
        Validate.notBlank((CharSequence)entity.getSpecialCode(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getSpecialName(), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u4ea7\u54c1\u7ef4\u5ea6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    @Override
    public void validatePolicyScope(AgreementTemplateVo agreementTemplateVo, AgreementPolicyDto agreementPolicyDto) {
        List materialCode;
        QuantifyPolicy quantifyPolicy = (QuantifyPolicy)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)agreementPolicyDto, QuantifyPolicy.class, HashSet.class, ArrayList.class, new String[]{"quantifyConfigurations", "quantifyConfigurations.quantifyRanges", "quantifyConfigurations.quantifyExpressions"}));
        List<String> createPolicyMaterialCodes = this.policyRangeValidation(quantifyPolicy);
        if (CollectionUtils.isEmpty(createPolicyMaterialCodes)) {
            return;
        }
        ProfitAgreementTemplatePaginationDto templatePaginationDto = new ProfitAgreementTemplatePaginationDto();
        if (!CollectionUtils.isEmpty((Collection)agreementTemplateVo.getTemplateOrgRelationships())) {
            List orgCodes = agreementTemplateVo.getTemplateOrgRelationships().stream().map(TemplateOrgRelationshipVo::getOrgCode).collect(Collectors.toList());
            templatePaginationDto.setOrgCodes(orgCodes);
        }
        templatePaginationDto.setEffectiveScopeStartTime(agreementTemplateVo.getEffectiveStartTime());
        templatePaginationDto.setEffectiveScopeEndTime(agreementTemplateVo.getEffectiveEndTime());
        templatePaginationDto.setStatus(EnableStatusEnum.ENABLE.getCode());
        List rangeDtos = this.agreementTemplateVoService.findListForConfirmQuantify(templatePaginationDto);
        if (CollectionUtils.isEmpty((Collection)rangeDtos)) {
            return;
        }
        HashSet<String> productLevelList = new HashSet<String>();
        HashSet<String> materialGroupCodeList = new HashSet<String>();
        HashSet<String> materialCodeList = new HashSet<String>();
        for (QuantifyRangeDto item : rangeDtos) {
            if (MaterialDimensionEnum.SERIES.getDictCode().equals(item.getDimensionFlag()) || MaterialDimensionEnum.MAX.getDictCode().equals(item.getDimensionFlag()) || MaterialDimensionEnum.MIN.getDictCode().equals(item.getDimensionFlag())) {
                productLevelList.add(item.getSpecialCode());
                continue;
            }
            if (MaterialDimensionEnum.MATERIAL_GROUP.getDictCode().equals(item.getDimensionFlag())) {
                materialGroupCodeList.add(item.getSpecialCode());
                continue;
            }
            if (!MaterialDimensionEnum.MATERIAL.getDictCode().equals(item.getDimensionFlag())) continue;
            materialCodeList.add(item.getSpecialCode());
        }
        if (CollectionUtils.isEmpty(productLevelList) && !CollectionUtils.isEmpty((Collection)(materialCode = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(new ArrayList(productLevelList), DimensionFlagEnum.SERIES.getCode())))) {
            materialCodeList.addAll(materialCode);
        }
        if (CollectionUtils.isEmpty(materialGroupCodeList) && !CollectionUtils.isEmpty((Collection)(materialCode = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(new ArrayList(materialGroupCodeList), DimensionFlagEnum.MATERIAL_GROUP.getCode())))) {
            materialCodeList.addAll(materialCode);
        }
        if (!CollectionUtils.isEmpty(materialCodeList)) {
            return;
        }
        createPolicyMaterialCodes.retainAll(materialCodeList);
        Validate.isTrue((boolean)CollectionUtils.isEmpty(materialCodeList), (String)"\u672c\u6b21\u521b\u5efa\u5305\u91cf\u4ea7\u54c1\u7269\u6599\u5df2\u7ecf\u521b\u5efa\u8fc7\u672c\u65f6\u6bb5\u5305\u91cf\u653f\u7b56\uff01", (Object[])new Object[0]);
    }

    @Override
    public void deleteByTemplateCode(String templateCode) {
        QueryWrapper quantifyPolicyQueryWrapper = new QueryWrapper();
        quantifyPolicyQueryWrapper.eq((Object)"template_code", (Object)templateCode);
        List quantifyPolicyList = ((QuantifyPolicyMapper)this.quantifyPolicyRepository.getBaseMapper()).selectList((Wrapper)quantifyPolicyQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)quantifyPolicyList)) {
            quantifyPolicyList.forEach(quantifyPolicy -> {
                QueryWrapper quantifyConfigurationQueryWrapper = new QueryWrapper();
                quantifyConfigurationQueryWrapper.eq((Object)"quantify_policy_id", (Object)quantifyPolicy.getId());
                List quantifyConfigurationList = ((QuantifyConfigurationMapper)this.quantifyConfigurationRepository.getBaseMapper()).selectList((Wrapper)quantifyConfigurationQueryWrapper);
                if (!CollectionUtils.isEmpty((Collection)quantifyConfigurationList)) {
                    quantifyConfigurationList.forEach(quantifyConfiguration -> {
                        QueryWrapper quantifyExpressionQueryWrapper = new QueryWrapper();
                        quantifyExpressionQueryWrapper.eq((Object)"configuration_id", (Object)quantifyConfiguration.getId());
                        ((QuantifyExpressionMapper)this.quantifyExpressionRepository.getBaseMapper()).delete((Wrapper)quantifyExpressionQueryWrapper);
                        QueryWrapper quantifyRangeQueryWrapper = new QueryWrapper();
                        quantifyExpressionQueryWrapper.eq((Object)"configuration_id", (Object)quantifyConfiguration.getId());
                        ((QuantifyRangeMapper)this.quantifyRangeRepository.getBaseMapper()).delete((Wrapper)quantifyRangeQueryWrapper);
                    });
                    ((QuantifyConfigurationMapper)this.quantifyConfigurationRepository.getBaseMapper()).delete((Wrapper)quantifyConfigurationQueryWrapper);
                }
            });
            ((QuantifyPolicyMapper)this.quantifyPolicyRepository.getBaseMapper()).delete((Wrapper)quantifyPolicyQueryWrapper);
        }
    }

    @Override
    public List<QuantifyPolicySign> findQuantifyPolicySignByAgreementIdList(List<String> agreementIdList) {
        if (CollectionUtils.isEmpty(agreementIdList)) {
            return new ArrayList<QuantifyPolicySign>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(QuantifyPolicySign::getAgreementId, agreementIdList);
        return ((QuantifyPolicySignMapper)this.quantifyPolicySignRepository.getBaseMapper()).selectList((Wrapper)queryWrapper);
    }

    private List<String> policyRangeValidation(QuantifyPolicy quantifyPolicy) {
        ArrayList materialCodes = Lists.newArrayList();
        Validate.isTrue((!CollectionUtils.isEmpty(quantifyPolicy.getQuantifyConfigurations()) ? 1 : 0) != 0, (String)"\u5305\u91cf\u653f\u7b56\u5fc5\u987b\u5305\u542b\u914d\u7f6e\uff01", (Object[])new Object[0]);
        quantifyPolicy.getQuantifyConfigurations().forEach(configuration -> {
            Validate.isTrue((!CollectionUtils.isEmpty(configuration.getQuantifyRanges()) ? 1 : 0) != 0, (String)"\u5305\u91cf\u653f\u7b56\u914d\u7f6e\u5fc5\u987b\u914d\u7f6e\u4ea7\u54c1\u7ef4\u5ea6\u8303\u56f4\uff01", (Object[])new Object[0]);
            List materialCodeList = this.materialVoService.findMaterialCodeByDimensionCodesAndDimensionType(configuration.getQuantifyRanges().stream().map(QuantifyRange::getSpecialCode).collect(Collectors.toList()), configuration.getDimensionFlag());
            if (!CollectionUtils.isEmpty((Collection)materialCodeList)) {
                materialCodes.addAll(materialCodeList);
            }
        });
        return materialCodes;
    }

    @Override
    public List<QuantifyPolicy> findByConditions(QuantifyPolicyDto quantifyPolicyDto) {
        if (Objects.isNull(quantifyPolicyDto)) {
            return null;
        }
        return this.quantifyPolicyRepository.findByConditions(quantifyPolicyDto);
    }
}

