/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.local.service.observer;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignNumConfirmObserver;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyPolicyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="quantifyPolicySignNumObserverImpl")
public class QuantifyPolicySignNumObserverImpl
implements AgreementSignNumConfirmObserver {
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;

    public Boolean onSuccess(AgreementSignDto dto) {
        if (dto == null || dto.getSignTotalNum() == null) {
            return false;
        }
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyService.findDetailByTemplateCode(dto.getTemplateCode());
        if (quantifyPolicy == null) {
            return false;
        }
        if (quantifyPolicy.getMinSale().compareTo(dto.getSignTotalNum()) > 0) {
            return false;
        }
        if (quantifyPolicy.getMaxSale().compareTo(dto.getSignTotalNum()) < 0) {
            return false;
        }
        return true;
    }
}

