/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.policy.quantify.local.service.observer;

import com.biz.crm.cps.business.agreement.sdk.dto.AgreementSignEventDto;
import com.biz.crm.cps.business.agreement.sdk.service.observer.AgreementSignNumSaveObserver;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicy;
import com.biz.crm.cps.business.policy.quantify.local.entity.QuantifyPolicySign;
import com.biz.crm.cps.business.policy.quantify.local.repository.QuantifyPolicySignRepository;
import com.biz.crm.cps.business.policy.quantify.local.service.QuantifyPolicyService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Component(value="quantifyPolicySignNumSaveObserverImpl")
public class QuantifyPolicySignNumSaveObserverImpl
implements AgreementSignNumSaveObserver {
    @Autowired
    private QuantifyPolicyService quantifyPolicyService;
    @Autowired
    private QuantifyPolicySignRepository quantifyPolicySignRepository;

    @Transactional
    public void onSuccess(List<AgreementSignEventDto> dtoList) {
        if (CollectionUtils.isEmpty(dtoList)) {
            return;
        }
        String templateCode = dtoList.get(0).getTemplateCode();
        QuantifyPolicy quantifyPolicy = this.quantifyPolicyService.findByTemplateCode(templateCode);
        if (quantifyPolicy != null) {
            ArrayList quantifyPolicySignList = new ArrayList();
            dtoList.forEach(item -> {
                QuantifyPolicySign quantifyPolicySign = new QuantifyPolicySign();
                quantifyPolicySign.setSignNum(item.getSignTotalNum());
                quantifyPolicySign.setAgreementId(item.getAgreementId());
                quantifyPolicySign.setTemplateCode(item.getTemplateCode());
                quantifyPolicySign.setCalculateCycle(quantifyPolicy.getCalculateCycle());
                quantifyPolicySign.setJanuarySaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getJanuarySaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setFebruarySaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getFebruarySaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setMarchSaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getMarchSaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setAprilSaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getAprilSaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setMaySaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getMaySaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setJuneSaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getJuneSaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setJulySaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getJulySaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setAugustSaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getAugustSaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setSeptemberSaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getSeptemberSaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setOctoberSaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getOctoberSaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setNovemberSaleNum(item.getSignTotalNum().multiply(quantifyPolicy.getNovemberSaleNum()).divide(BigDecimal.valueOf(100L), 2, 4));
                quantifyPolicySign.setDecemberSaleNum(item.getSignTotalNum().subtract(quantifyPolicySign.getJanuarySaleNum()).subtract(quantifyPolicySign.getFebruarySaleNum()).subtract(quantifyPolicySign.getMarchSaleNum()).subtract(quantifyPolicySign.getAprilSaleNum()).subtract(quantifyPolicySign.getMaySaleNum()).subtract(quantifyPolicySign.getJuneSaleNum()).subtract(quantifyPolicySign.getJulySaleNum()).subtract(quantifyPolicySign.getAugustSaleNum()).subtract(quantifyPolicySign.getSeptemberSaleNum()).subtract(quantifyPolicySign.getOctoberSaleNum()).subtract(quantifyPolicySign.getNovemberSaleNum()));
                quantifyPolicySignList.add(quantifyPolicySign);
            });
            this.quantifyPolicySignRepository.saveBatch(quantifyPolicySignList);
        }
    }
}

