package com.biz.crm.cps.bisiness.policy.quantify.sdk.constant;

/**
 * @author jerry7
 * 包量任务状态枚举
 */
public enum QuantifyTaskStatusEnum {

  /**
   * 未开始
   */
  STATUS_WAIT("0", "未开始"),

  /**
   * 进行中
   */
  STATUS_DOING("1", "进行中"),

  /**
   * 已完成/已分利
   */
  STATUS_COMPLETE("2", "已完成/已分利"),

  /**
   * 已完成/已分利
   */
  STATUS_EXPIRED("3", "已过期");

  private String code;

  private String desc;

  private QuantifyTaskStatusEnum(String code, String desc) {
    this.code = code;
    this.desc = desc;
  }

  public String getCode() {
    return code;
  }

  public String getDesc() {
    return desc;
  }
}
