package com.biz.crm.cps.bisiness.policy.quantify.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author jerry7
 * @date 2021/8/7 16:08
 * 包量政策分利表达式实体Dto
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyExpressionDto", description = "包量政策分利表达式实体Dto")
public class QuantifyExpressionDto implements Serializable {

  /**
   * 包量达成计算周期(月,季度，半年，年)
   */
  @ApiModelProperty("包量达成计算周期(月,季度，半年，年)")
  @TableField(value = "calculate_cycle")
  @Column(name = "calculate_cycle", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 包量计算达成周期(月,季度，半年，年) '")
  private String calculateCycle;

  /**
   * 包量政策配置id
   */
  @ApiModelProperty("包量政策配置id")
  @TableField(value = "configuration_id")
  @Column(name = "configuration_id", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 包量政策id '")
  private String configurationId;

  /**
   * 奖励条件标志(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件标志(固定额度，定额随机)")
  @TableField(value = "award_condition_flag")
  @Column(name = "award_condition_flag", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 奖励条件标志(固定额度，定额随机) '")
  private String awardConditionFlag;

  /**
   * 奖励条件名称(固定额度，定额随机)
   */
  @ApiModelProperty("奖励条件名称(固定额度，定额随机)")
  @TableField(value = "award_condition_name")
  @Column(name = "award_condition_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 奖励条件名称(固定额度，定额随机) '")
  private String awardConditionName;

  /**
   * 奖励方式标志
   */
  @ApiModelProperty("奖励方式标志")
  @TableField(value = "reward_method_flag")
  @Column(name = "reward_method_flag", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励方式标志 '")
  private String rewardMethodFlag;

  /**
   * 奖励方式名称
   */
  @Column(name = "reward_method_name", nullable = false, length = 16, columnDefinition = "VARCHAR(16) COMMENT ' 奖励方式名称 '")
  @ApiModelProperty("奖励方式名称")
  @TableField(value = "reward_method_name")
  private String rewardMethodName;

  /**
   * 赠品编码
   */
  @ApiModelProperty("赠品编码")
  @Column(name = "gift_code", nullable = false, length = 16, columnDefinition = "VARCHAR(128) COMMENT ' 赠品编码 '")
  @TableField(value = "gift_code")
  private String giftCode;

  /**
   * 阶梯达成比例
   */
  @ApiModelProperty("阶梯达成比例")
  private BigDecimal reachRate;

  /**
   * 奖励数据
   */
  @ApiModelProperty("奖励数据")
  private BigDecimal rewardData;

  /**
   * 表达式特殊编码
   */
  @ApiModelProperty("表达式特殊编码")
  private String specialCode;
}
