package com.biz.crm.cps.bisiness.policy.quantify.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.List;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021/8/11 9:51
 * 包量政策实体DTO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyPolicyDto", description = "包量政策实体Dto")
public class QuantifyPolicyDto extends AgreementPolicyDto {
  /**
   * 模板编码
   */
  @ApiModelProperty("模板编码")
  @TableField(value = "template_code")
  @Column(name = "template_code", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 协议模板id '")
  private String templateCode;

  /**
   * 总销量（标箱）
   */
  @ApiModelProperty("总销量（标箱）")
  private BigDecimal totalSale;

  /**
   * 一月份销量（标箱）
   */
  @ApiModelProperty("一月份销量（标箱）")
  private BigDecimal januarySaleNum;

  /**
   * 二月份销量（标箱）
   */
  @ApiModelProperty("二月份销量（标箱）")
  private BigDecimal februarySaleNum;

  /**
   * 三月份销量（标箱）
   */
  @ApiModelProperty("三月份销量（标箱）")
  private BigDecimal marchSaleNum;

  /**
   * 四月份销量（标箱）
   */
  @ApiModelProperty("四月份销量（标箱）")
  private BigDecimal aprilSaleNum;

  /**
   * 五月份销量（标箱）
   */
  @ApiModelProperty("五月份销量（标箱）")
  private BigDecimal maySaleNum;

  /**
   * 六月份销量（标箱）
   */
  @ApiModelProperty("六月份销量（标箱）")
  private BigDecimal juneSaleNum;

  /**
   * 七月份销量（标箱）
   */
  @ApiModelProperty("七月份销量（标箱）")
  private BigDecimal julySaleNum;

  /**
   * 八月份销量（标箱）
   */
  @ApiModelProperty("八月份销量（标箱）")
  private BigDecimal augustSaleNum;

  /**
   * 九月份销量（标箱）
   */
  @ApiModelProperty("九月份销量（标箱）")
  private BigDecimal septemberSaleNum;

  /**
   * 十月份销量（标箱）
   */
  @ApiModelProperty("十月份销量（标箱）")
  private BigDecimal octoberSaleNum;

  /**
   * 十一月份销量（标箱）
   */
  @ApiModelProperty("十一月份销量（标箱）")
  private BigDecimal novemberSaleNum;

  /**
   * 十二月份销量（标箱）
   */
  @ApiModelProperty("十二月份销量（标箱）")
  private BigDecimal decemberSaleNum;

  /**
   * 包量达成计算周期(月,季度，半年，年)
   */
  @ApiModelProperty("包量达成计算周期(月,季度，半年，年)")
  private String calculateCycle;

  /**
   * 扫码产品维度标识
   */
  @ApiModelProperty("扫码产品维度标识")
  @TableField(value = "dimension_flag")
  @Column(name = "dimension_flag", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 扫码产品维度标识 '")
  private String dimensionFlag;

  /**
   * 扫码产品维度名称
   */
  @ApiModelProperty("扫码产品维度名称")
  @TableField(value = "dimension_name")
  @Column(name = "dimension_name", nullable = false, length = 64, columnDefinition = "VARCHAR(64) COMMENT ' 扫码产品维度名称 '")
  private String dimensionName;

  /**
   * 政策关联配置列表
   */
  @ApiModelProperty("政策关联配置列表")
  @TableField(exist = false)
  private Set<QuantifyConfigurationDto> quantifyConfigurations;

  /**
   * 协议模板编码列表
   */
  @ApiModelProperty("协议模板编码列表")
  private List<String> templateCodes;

}
