package com.biz.crm.cps.bisiness.policy.quantify.sdk.dto;

import com.baomidou.mybatisplus.annotation.TableField;
import com.biz.crm.cps.business.agreement.sdk.dto.AgreementPolicyDto;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;

/**
 * @author jerry7
 * @date 2021/8/11 9:51
 * 包量政策实体DTO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyTaskDto", description = "包量任务实体Dto")
public class QuantifyTaskDto  {

  /**
   * 业务单号(生成包量任务时生成)
   */
  @ApiModelProperty("业务单号")
  private String businessCode;

  /**
   * 包量政策id
   */
  @ApiModelProperty("包量政策id")
  private String quantifyPolicyId;

  /**
   * 所属协议id
   */
  @ApiModelProperty("所属协议id")
  private String agreementId;

  /**
   * 所属协议名称
   */
  @ApiModelProperty("所属协议名称")
  private String agreementName;

  /**
   * 所属模板id
   */
  @ApiModelProperty("所属模板id")
  private String templateId;

  /**
   * 所属模板名称
   */
  @ApiModelProperty("所属模板名称")
  private String templateName;

  /**
   * 终端编码
   */
  @ApiModelProperty("终端编码")
  private String terminalCode;

  /**
   * 终端名称
   */
  @ApiModelProperty("终端名称")
  private String terminalName;

  /**
   * 达成比例
   */
  @ApiModelProperty("达成比例")
  private BigDecimal reachRate;

  /**
   * 分利红包
   */
  @ApiModelProperty("分利红包")
  private BigDecimal redPacket;

  /**
   * 分利金额
   */
  @ApiModelProperty("分利金额")
  private BigDecimal shareAmount;

  /**
   * 分利积分
   */
  @ApiModelProperty("分利积分")
  private BigDecimal shareIntegral;

  /**
   * 任务名称(根据时间和协议，政策进行生成)
   */
  @ApiModelProperty("任务名称")
  private String taskName;

  /**
   * 任务类型(年度，半年度，季度，月度)
   */
  @ApiModelProperty("任务类型(年度，半年度，季度，月度)")
  private String taskType;

  /**
   * 任务开始时间
   */
  @ApiModelProperty("任务开始时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskStartTime;

  /**
   * 任务结束时间
   */
  @ApiModelProperty("任务结束时间")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
  private Date taskEndTime;

  /**
   * 任务状态(未开始，进行中，已分利)
   */
  @ApiModelProperty("任务状态(未开始，进行中，已分利)")
  private String taskStatus;

}
