package com.biz.crm.cps.bisiness.policy.quantify.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;

/**
 * @author jerry7
 * @date 2021/8/9 16:29
 * 包量任务统计VO
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "QuantifyTask", description = "包量政策任务实体")
public class QuantifyTaskStatisticsVo  {
  private static final long serialVersionUID = -779243171144160443L;

  /**
   * 进行中任务数量
   */
  @ApiModelProperty("进行中任务数量")
  private Integer doingTaskNumber;

  /**
   * 已完成任务数量
   */
  @ApiModelProperty("已完成任务数量")
  private Integer completeTaskNumber;

  /**
   * 分利红包
   */
  @ApiModelProperty("分利红包")
  private BigDecimal redPacket;

  /**
   * 分利金额
   */
  @ApiModelProperty("分利金额")
  private BigDecimal shareAmount;

  /**
   * 分利积分
   */
  @ApiModelProperty("分利积分")
  private BigDecimal shareIntegral;

}
