package com.biz.crm.cps.bisiness.policy.quantify.sdk.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Map;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 扫码政策任务完成情况主信息实体
 *
 * @author sunx
 * @date 2021/12/9
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "ScanCodeQuantityTaskVo", description = "扫码政策任务完成情况主信息实体")
public class ScanCodeQuantityTaskVo {

  /** 包量任务名 */
  @ApiModelProperty("包量任务名")
  private String taskName;

  /** 任务类型key集合 */
  @ApiModelProperty("任务类型key集合")
  private List<String> timeKeyList;

  /** 任务类型明细 */
  @ApiModelProperty("任务类型明细key-month,v-完成量")
  private Map<String, ScanCodeQuantityTaskItemVo> map;
}
