/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketDetailEntity;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketDetailRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.KeepBooksService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDetailDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDto;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class RedPacketDetailServiceImpl
implements RedPacketDetailService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketDetailServiceImpl.class);
    @Autowired
    private RedPacketDetailRepository redPacketDetailRepository;
    @Autowired(required=false)
    private LoginUserService loginUserService;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    private RedPacketService redPacketService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private KeepBooksService keepBooksService;

    @Override
    public Page<RedPacketDetailEntity> findByConditions(Pageable pageable, RedPacketDetailDto dto) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (dto == null) {
            dto = new RedPacketDetailDto();
        }
        dto.setTenantCode(TenantUtils.getTenantCode());
        return this.redPacketDetailRepository.findByConditions(pageable, dto);
    }

    @Override
    public BigDecimal sumByLastDay(String lastDay) {
        Validate.notBlank((CharSequence)lastDay, (String)"\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        BigDecimal amount = this.redPacketDetailRepository.sumByLastDay(lastDay);
        if (amount == null) {
            return BigDecimal.ZERO;
        }
        return amount;
    }

    @Override
    @Transactional
    public RedPacketDetailEntity create(RedPacketDetailDto redPacketDetailDto) {
        log.debug("\u65b0\u589e\u7ea2\u5305\u6d41\u6c34\u4f20\u5165\u53c2\u6570={}", (Object)redPacketDetailDto);
        RedPacketDetailEntity redPacketDetail = (RedPacketDetailEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDetailDto, RedPacketDetailEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.createForm(redPacketDetail);
        RedPacketEntity old = this.redPacketService.findByParticipatorCode(redPacketDetail.getParticipatorCode());
        if (old != null) {
            RedPacketDto redPacketDto = (RedPacketDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)old, RedPacketDto.class, HashSet.class, ArrayList.class, new String[0]);
            BigDecimal balance = old.getBalance() == null ? BigDecimal.ZERO : old.getBalance();
            BigDecimal accruingRedPacket = old.getAccruingRedPacket() == null ? BigDecimal.ZERO : old.getAccruingRedPacket();
            balance = balance.add(redPacketDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
            accruingRedPacket = accruingRedPacket.add(redPacketDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
            redPacketDto.setBalance(balance);
            redPacketDto.setAccruingRedPacket(accruingRedPacket);
            redPacketDto.setOrgCode(redPacketDetailDto.getOrgCode());
            redPacketDto.setOrgName(redPacketDetailDto.getOrgName());
            redPacketDto.setChannel(redPacketDetailDto.getChannel());
            this.redPacketService.update(redPacketDto);
            redPacketDetail.setRedPacketId(old.getId());
        } else {
            RedPacketDto redPacket = (RedPacketDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDetailDto, RedPacketDto.class, HashSet.class, ArrayList.class, new String[0]);
            redPacket.setBalance(redPacketDetail.getAmount());
            redPacket.setAccruingRedPacket(redPacketDetail.getAmount());
            RedPacketEntity returnEntity = this.redPacketService.create(redPacket);
            redPacketDetail.setRedPacketId(returnEntity.getId());
        }
        this.keepBooksService.updateTop1SubBalance(redPacketDetail.getAmount());
        this.redPacketDetailRepository.saveOrUpdate((Object)redPacketDetail);
        return redPacketDetail;
    }

    private RedPacketDetailEntity createForm(RedPacketDetailEntity redPacketDetail) {
        if (Objects.nonNull(this.generateCodeService)) {
            redPacketDetail.setCode((String)this.generateCodeService.generateCode("HB", 1).get(0));
        }
        redPacketDetail.setTenantCode(TenantUtils.getTenantCode());
        redPacketDetail.setCreateTime(new Date());
        redPacketDetail.setCreateAccount(this.loginUserService.getLoginAccountName());
        redPacketDetail.setModifyTime(new Date());
        redPacketDetail.setModifyAccount(this.loginUserService.getLoginAccountName());
        redPacketDetail.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        redPacketDetail.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.createValidation(redPacketDetail);
        RedPacketDetailEntity lastPacketDetail = this.redPacketDetailRepository.findTop1ByParticipatorCode(redPacketDetail.getParticipatorCode());
        if (lastPacketDetail != null) {
            BigDecimal balance = lastPacketDetail.getBalance() == null ? BigDecimal.ZERO : lastPacketDetail.getBalance();
            balance = balance.add(redPacketDetail.getAmount()).setScale(4, RoundingMode.HALF_UP);
            redPacketDetail.setBalance(balance);
        } else {
            redPacketDetail.setBalance(redPacketDetail.getAmount());
        }
        return redPacketDetail;
    }

    private void createValidation(RedPacketDetailEntity redPacketDetail) {
        Validate.notNull((Object)((Object)redPacketDetail), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getAgreementCode(), (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u534f\u8bae\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDetail.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getAgreementCode().length() < 255 ? 1 : 0) != 0, (String)"\u534f\u8bae\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDetail.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    public List<RedPacketDetailEntity> findByParticipatorCodeAndCreateTime(String participatorCode, String yearAndMonth) {
        if (StringUtils.isBlank((CharSequence)participatorCode)) {
            return Lists.newArrayList();
        }
        return this.redPacketDetailRepository.findByParticipatorCodeAndCreateTime(participatorCode, yearAndMonth);
    }

    @Override
    public BigDecimal sumByParticipatorCodeAndRecordCodes(String participatorCode, List<String> recordCodes) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(recordCodes, (String)"\u626b\u7801\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        BigDecimal total = this.redPacketDetailRepository.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
        return total;
    }
}

