/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.cps.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.cps.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.reward.redpacket.local.entity.RedPacketEntity;
import com.biz.crm.cps.business.reward.redpacket.local.repository.RedPacketRepository;
import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketService;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.CustomerRedPacketBalanceDto;
import com.biz.crm.cps.business.reward.redpacket.sdk.dto.RedPacketDto;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"RedPacketServiceExpandImpl"})
public class RedPacketServiceImpl
implements RedPacketService {
    private static final Logger log = LoggerFactory.getLogger(RedPacketServiceImpl.class);
    @Autowired
    private RedPacketRepository redPacketRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private LoginUserService loginUserService;

    @Override
    public Page<RedPacketEntity> findByConditions(CustomerRedPacketBalanceDto balanceDto, Pageable pageable) {
        ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        if (balanceDto == null) {
            balanceDto = new CustomerRedPacketBalanceDto();
        }
        balanceDto.setTenantCode(TenantUtils.getTenantCode());
        return this.redPacketRepository.findByConditions(pageable, balanceDto);
    }

    @Override
    public RedPacketEntity findByParticipatorCode(String participatorCode) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u6d3b\u52a8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        return this.redPacketRepository.findByParticipatorCode(participatorCode);
    }

    @Override
    @Transactional
    public RedPacketEntity create(RedPacketDto redPacketDto) {
        log.debug("\u4fdd\u5b58\u7ea2\u5305\u4fe1\u606f\u5165\u53c2={}", (Object)redPacketDto);
        this.createValidation(redPacketDto);
        RedPacketEntity redPacketEntity = (RedPacketEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDto, RedPacketEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.createForm(redPacketEntity);
        this.redPacketRepository.saveOrUpdate((Object)redPacketEntity);
        return redPacketEntity;
    }

    @Override
    @Transactional
    public RedPacketEntity update(RedPacketDto redPacketDto) {
        this.updateValidation(redPacketDto);
        RedPacketEntity redPacketEntity = (RedPacketEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)redPacketDto, RedPacketEntity.class, HashSet.class, ArrayList.class, new String[0]));
        RedPacketEntity old = (RedPacketEntity)((Object)this.redPacketRepository.getById((Serializable)((Object)redPacketEntity.getId())));
        Validate.notNull((Object)((Object)old), (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        BeanUtils.copyProperties((Object)((Object)redPacketEntity), (Object)((Object)old), (String[])new String[]{"id", "modifyTime", "createAccount", "createTime", "tenantCode"});
        Date now = new Date();
        String account = this.loginUserService.getLoginAccountName();
        old.setModifyAccount(account);
        old.setModifyTime(now);
        this.redPacketRepository.saveOrUpdate((Object)old);
        return old;
    }

    private void updateValidation(RedPacketDto redPacketDto) {
        Validate.notNull((Object)redPacketDto, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u4fee\u6539\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0cid\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createValidation(RedPacketDto redPacketDto) {
        Validate.notNull((Object)redPacketDto, (String)"\u65b0\u589e\u64cd\u4f5c\u65f6\uff0c\u65b0\u589e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorType(), (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorCode(), (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)redPacketDto.getParticipatorName(), (String)"\u53c2\u4e0e\u8005\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a;", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorType().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7c7b\u578b\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorCode().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((redPacketDto.getParticipatorName().length() < 255 ? 1 : 0) != 0, (String)"\u53c2\u4e0e\u8005\u540d\u79f0\uff0c\u5728\u8fdb\u884c\u6dfb\u52a0\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(255)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private void createForm(RedPacketEntity redPacketEntity) {
        redPacketEntity.setId(null);
        redPacketEntity.setTenantCode(TenantUtils.getTenantCode());
        redPacketEntity.setCreateTime(new Date());
        redPacketEntity.setCreateAccount(this.loginUserService.getLoginAccountName());
        redPacketEntity.setModifyTime(new Date());
        redPacketEntity.setModifyAccount(this.loginUserService.getLoginAccountName());
        redPacketEntity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        redPacketEntity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
    }
}

