/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketParticipatorRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelParticipatorServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.ParticipatorRewardStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelParticipatorItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="RedPacketRewardRelParticipatorServiceObserverImpl")
public class RedPacketRewardRelParticipatorServiceObserverImpl
implements RewardRelParticipatorServiceObserver {
    @Autowired
    @Qualifier(value="RedpacketRewardMountRegisterServiceImpl")
    private RewardMountRegister rewardMountRegister;
    @Autowired
    private RedPacketParticipatorRewardStatisticsVoService redPacketParticipatorRewardStatisticsVoService;

    public List<RewardRelParticipatorItemVo> onRequestRewardRelParticipatorItems(List<String> participatorCodes) {
        Validate.notEmpty(participatorCodes, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List result = this.redPacketParticipatorRewardStatisticsVoService.findByParticipatorCodes(participatorCodes);
        ArrayList list = Lists.newArrayList();
        for (String participatorCode : participatorCodes) {
            RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
            ParticipatorRewardStatisticsVo statisticsVo = result.stream().filter(item -> Objects.equals(participatorCode, item.getParticipatorCode())).findFirst().orElse(null);
            vo.setName(this.rewardMountRegister.getName());
            vo.setFlag(this.rewardMountRegister.getFlag());
            vo.setKey(this.rewardMountRegister.getKey());
            vo.setAmount(statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getAmount());
            vo.setBalance(statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getBalance());
            RewardRelParticipatorItemVo item2 = new RewardRelParticipatorItemVo();
            item2.setParticipatorCode(participatorCode);
            item2.setRewardStatisticsVo(vo);
            list.add(item2);
        }
        return list;
    }
}

