/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.sdk.service.RedPacketScanCodeRewardStatisticsVoService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardRelScanCodeServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardRelScanCodeItemVo;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import com.biz.crm.cps.business.reward.sdk.vo.ScanCodeRewardStatisticsVo;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="RedPacketRewardRelScanCodeServiceObserverImpl")
public class RedPacketRewardRelScanCodeServiceObserverImpl
implements RewardRelScanCodeServiceObserver {
    @Autowired
    @Qualifier(value="RedpacketRewardMountRegisterServiceImpl")
    private RewardMountRegister rewardMountRegister;
    @Autowired
    private RedPacketScanCodeRewardStatisticsVoService redPacketScanCodeRewardStatisticsVoService;

    public List<RewardRelScanCodeItemVo> onRequestRewardRelScanCodeItems(String participatorCode, List<String> recordCodes) {
        Validate.notEmpty((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List result = this.redPacketScanCodeRewardStatisticsVoService.findByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
        ArrayList list = Lists.newArrayList();
        for (String recordCode : recordCodes) {
            RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
            ScanCodeRewardStatisticsVo statisticsVo = result.stream().filter(item -> Objects.equals(recordCode, item.getRecordCode())).findFirst().orElse(null);
            vo.setName(this.rewardMountRegister.getName());
            vo.setFlag(this.rewardMountRegister.getFlag());
            vo.setKey(this.rewardMountRegister.getKey());
            vo.setAmount(statisticsVo == null ? BigDecimal.ZERO : statisticsVo.getAmount());
            RewardRelScanCodeItemVo item2 = new RewardRelScanCodeItemVo();
            item2.setRecordCode(recordCode);
            item2.setRewardStatisticsVo(vo);
            list.add(item2);
        }
        return list;
    }
}

