/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cps.business.reward.redpacket.local.service.observer;

import com.biz.crm.cps.business.reward.redpacket.local.service.RedPacketDetailService;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardMountRegister;
import com.biz.crm.cps.business.reward.sdk.service.observer.RewardTypeStatisticsServiceObserver;
import com.biz.crm.cps.business.reward.sdk.vo.RewardTypeStatisticsVo;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="RedPacketRewardTypeStatisticsServiceObserverImpl")
public class RedPacketRewardTypeStatisticsServiceObserverImpl
implements RewardTypeStatisticsServiceObserver {
    @Autowired
    @Qualifier(value="RedpacketRewardMountRegisterServiceImpl")
    private RewardMountRegister rewardMountRegister;
    @Autowired
    private RedPacketDetailService redPacketDetailService;

    public RewardTypeStatisticsVo onRequestRewardTypeStatisticsVo(String participatorCode, List<String> recordCodes) {
        Validate.notBlank((CharSequence)participatorCode, (String)"\u53c2\u4e0e\u8005\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notEmpty(recordCodes, (String)"\u626b\u7801\u8bb0\u5f55\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        RewardTypeStatisticsVo vo = new RewardTypeStatisticsVo();
        vo.setName(this.rewardMountRegister.getName());
        vo.setFlag(this.rewardMountRegister.getFlag());
        vo.setKey(this.rewardMountRegister.getKey());
        BigDecimal total = this.redPacketDetailService.sumByParticipatorCodeAndRecordCodes(participatorCode, recordCodes);
        vo.setAmount(total == null ? BigDecimal.ZERO : total);
        return vo;
    }
}

