package com.biz.crm.cps.business.reward.cost.local.controller;

import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerBillService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 经销商费用上账
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "经销商费用上账")
@Slf4j
@RestController
@RequestMapping("/v1/cost/dealerBill")
public class CostDealerBillController {

  @Autowired
  private CostDealerBillService costDealerBillService;

  /**
   * 创建上账
   * @param dealerBills
   * @return
   */
  @ApiOperation(value = "创建上账")
  @PostMapping(value = "")
  public Result<?> create(@RequestBody @ApiParam(name = "dealerBill", value = "上账") List<CostDealerDetailEntity> dealerBills) {
    try {
      this.costDealerBillService.create(dealerBills);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
