package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerBillDto;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostDealerBillVoService;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDealerBillVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经销商费用上账
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "经销商费用上账")
@Slf4j
@RestController
@RequestMapping("/v1/cost/dealerBill")
public class CostDealerBillVoController {

  @Autowired
  private CostDealerBillVoService costDealerBillVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<CostDealerBillVo>> findByConditions(@ApiParam(name = "costDealerBillDto", value = "终端分页Dto") CostDealerBillDto costDealerBillDto,
                                                         @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostDealerBillVo> result = this.costDealerBillVoService.findByConditions(costDealerBillDto, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
