package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经销商费用
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "经销商费用")
@Slf4j
@RestController
@RequestMapping("/v1/cost/dealer")
public class CostDealerController {

  @Autowired
  private CostDealerService costDealerService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<CostDealerEntity>> findByConditions(@ApiParam(name = "costDealerDto", value = "终端分页Dto") CostDealerDto costDealerDto,
                                                         @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostDealerEntity> result = this.costDealerService.findByConditions(costDealerDto, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据编码查询
   * @return
   */
  @ApiOperation(value = "根据编码查询")
  @GetMapping("findByDealerCode")
  public Result<CostDealerEntity> findByDealerCode(@RequestParam(value = "dealerCode") @ApiParam(name = "dealerCode", value = "经销商编码") String terminalCode) {
    try {
      CostDealerEntity result = this.costDealerService.findByDealerCode(terminalCode);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 根据当前登陆人编码查询
   * @return
   */
  @ApiOperation(value = "根据当前登陆人编码查询")
  @GetMapping("findByCurrentUser")
  public Result<CostDealerEntity> findByCurrentUser() {
    try {
      LoginUserDetailsForCPS userDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      CostDealerEntity result = this.costDealerService.findByDealerCode(userDetails.getConsumerCode());
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
