package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.entity.CostDealerDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经销商费用明细
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "经销商费用明细")
@Slf4j
@RestController
@RequestMapping("/v1/cost/dealerDetail")
public class CostDealerDetailController {

  @Autowired
  private CostDealerDetailService costDealerDetailService;

  /**
   * 根据经销商费用id查询明细
   * @return
   */
  @ApiOperation(value = "根据经销商费用id查询明细")
  @GetMapping("findByCostDealerId")
  public Result<Page<CostDealerDetailEntity>> findByCostDealerId(@ApiParam(name = "costDealerId", value = "根据经销商费用id") String costDealerId,
                                                                 @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostDealerDetailEntity> result = this.costDealerDetailService.findByCostDealerId(costDealerId, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 方法内部流程：
   * 根据外部接口PolicyRewardServiceObserver获取入参
   * 根据奖励类型判定是否需要记录经销商费用流水信息
   * 通过费用类型计算费用金额
   * 修改客户费用余额信息
   * 记录费用流水信息和客户费用信息
   *
   * @param costDealerDetailEntity
   */
  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<CostDealerDetailEntity> create(@RequestBody @ApiParam(name = "costDealerDetailEntity", value = "经销商费用明细") CostDealerDetailEntity costDealerDetailEntity) {
    try {
      CostDealerDetailEntity current = this.costDealerDetailService.create(costDealerDetailEntity);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
