package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.service.CostDealerDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDealerDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDealerDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 经销商费用明细
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "经销商费用明细")
@Slf4j
@RestController
@RequestMapping("/v1/cost/dealerDetail")
public class CostDealerDetailVoController {

  @Autowired
  private CostDealerDetailVoService costDealerDetailVoService;

  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<CostDealerDetailVo>> findByConditions(@ApiParam(name = "costDealerDetailDto", value = "终端分页Dto")CostDealerDetailDto costDealerDetailDto,
                                                           @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostDealerDetailVo> result = this.costDealerDetailVoService.findByConditions(costDealerDetailDto, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
