package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.participator.sdk.common.enums.ParticipatorTypeEnum;
import com.biz.crm.cps.business.reward.cost.local.service.CostDetailVoService;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostDetailDto;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostDetailVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @Author: zengxingwang
 * @Date: 2021/9/2 14:12
 */
@Api(tags = "H5明细统计")
@Slf4j
@RestController
@RequestMapping("/v1/cost/detail")
public class CostDetailVoController {

  @Autowired
  private CostDetailVoService costDetailVoService;
  @Autowired(required = false)
  private LoginUserService loginUserService;

  /**
   * 多条件分页查询
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<CostDetailVo>> findByConditions(@RequestParam @ApiParam(name = "yearAndMonth", value = "年月") String yearAndMonth,
                                                     @RequestParam @ApiParam(name = "type", value = "(不传:全部，1.收入2.支出)") Integer type,
                                                     @PageableDefault(50) Pageable pageable) {
    try {
      LoginUserDetailsForCPS userDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      ParticipatorTypeEnum participatorTypeEnum = ParticipatorTypeEnum.getByKey(userDetails.getUsertype());
      Page<CostDetailVo> result = this.costDetailVoService.findByConditions(userDetails.getConsumerCode(), participatorTypeEnum.getDictCode(), yearAndMonth, type, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * 创建费用明细
   * @return
   */
  @ApiOperation(value = "创建费用明细")
  @PostMapping("create")
  public Result<?> create(@RequestBody @ApiParam(name = "CostDetailDto", value = "创建费用明细") CostDetailDto dto) {
    try {
      this.costDetailVoService.create(dto);
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
