package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.local.entity.CostTerminalDetailEntity;
import com.biz.crm.cps.business.reward.cost.local.service.CostTerminalBillService;
import com.biz.crm.cps.business.reward.cost.sdk.common.CostRedisKeys;
import com.biz.crm.cps.business.reward.cost.sdk.dto.ApproveDto;
import com.bizunited.nebula.common.service.redis.RedisMutexService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.concurrent.TimeUnit;

/**
 * 终端费用上账
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "终端费用上账")
@Slf4j
@RestController
@RequestMapping("/v1/cost/terminalBill")
public class CostTerminalBillController {

  @Autowired
  private CostTerminalBillService costTerminalBillService;
  @Autowired
  private LoginUserService loginUserService;
  @Autowired
  private RedisMutexService redisMutexService;

  /**
   * 创建上账
   * @param terminalBillEntity
   * @return
   */
  @ApiOperation(value = "创建上账")
  @PostMapping(value = "")
  public Result<CostTerminalDetailEntity> create(@RequestBody @ApiParam(name = "terminalBillEntity", value = "上账") CostTerminalDetailEntity terminalBillEntity) {
    String redisKey = String.format(CostRedisKeys.TENANT_BUSINESS_LOCK_PREFIX, terminalBillEntity.getTerminalCode());
    Validate.isTrue(redisMutexService.tryLock(redisKey, TimeUnit.SECONDS, 20), "核销申请繁忙请稍后再试！");
    try {
      LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      terminalBillEntity.setTerminalCode(loginUser.getConsumerCode());
      CostTerminalDetailEntity current = this.costTerminalBillService.create(terminalBillEntity);
      return Result.ok(current);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    } finally {
      redisMutexService.unlock(redisKey);
    }
  }

  /**
   * 批量审批
   * @param approveDto
   * @return
   */
  @ApiOperation(value = "批量审批")
  @PostMapping(value = "approve")
  public Result<?> approve(@RequestBody @ApiParam(name = "approveDto") ApproveDto approveDto) {
    try {
      LoginUserDetailsForCPS loginUser = loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      this.costTerminalBillService.approve(approveDto.getIds(), approveDto.getReviewStatus(), loginUser.getConsumerCode());
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }


  /**
   * 费用审核-待审核页面
   * @return
   */
  @ApiOperation(value = "费用审核-待审核页面")
  @GetMapping("findByDealerCode")
  public Result<Page<CostTerminalDetailEntity>> findByDealerCode(@RequestParam(value = "dealerCode") @ApiParam(name = "dealerCode", value = "经销商编码") String dealerCode,
                                                               @RequestParam(value = "reviewStatus") @ApiParam(name = "reviewStatus", value = "审核状态(1.待审核2.通过3.驳回)") Integer reviewStatus,
                                                               @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostTerminalDetailEntity> result = this.costTerminalBillService.findByDealerCode(dealerCode, reviewStatus, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
