package com.biz.crm.cps.business.reward.cost.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.LoginUserDetailsForCPS;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.cps.business.common.local.model.Result;
import com.biz.crm.cps.business.reward.cost.sdk.dto.CostTerminalBillDto;
import com.biz.crm.cps.business.reward.cost.sdk.service.CostTerminalBillVoService;
import com.biz.crm.cps.business.reward.cost.sdk.vo.CostTerminalBillVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 终端费用上账
 * @Author: zengxingwang
 * @Date: 2021/8/20 9:42
 */
@Api(tags = "终端费用上账")
@Slf4j
@RestController
@RequestMapping("/v1/cost/terminalBill")
public class CostTerminalBillVoController {

  @Autowired
  private CostTerminalBillVoService costTerminalBillVoService;
  @Autowired(required = false)
  private LoginUserService loginUserService;
  /**
   * 多条件分页查询
   *
   * @return
   */
  @ApiOperation(value = "多条件分页查询")
  @GetMapping("findByConditions")
  public Result<Page<CostTerminalBillVo>> findByConditions(@ApiParam(name = "costTerminalBillDto", value = "终端分页Dto") CostTerminalBillDto costTerminalBillDto,
                                                           @PageableDefault(50) Pageable pageable) {
    try {
      Page<CostTerminalBillVo> result = this.costTerminalBillVoService.findByConditions(costTerminalBillDto, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  /**
   * H5根据状态和时间查询
   * @return
   */
  @ApiOperation(value = "H5根据状态和时间查询")
  @GetMapping("findByReviewStatusAndTime")
  public Result<Page<CostTerminalBillVo>> findByReviewStatusAndTime(@ApiParam(name = "reviewStatus", value = "状态") Integer reviewStatus,
                                                                          @ApiParam(name = "yearAndMonth", value = "年月") String yearAndMonth,
                                                                          @PageableDefault(50) Pageable pageable) {
    try {
      LoginUserDetailsForCPS userDetails = this.loginUserService.getLoginDetails(LoginUserDetailsForCPS.class);
      CostTerminalBillDto costTerminalBillDto = new CostTerminalBillDto();
      costTerminalBillDto.setReviewStatus(reviewStatus);
      costTerminalBillDto.setYearAndMonth(yearAndMonth);
      costTerminalBillDto.setTerminalCode(userDetails.getConsumerCode());
      Page<CostTerminalBillVo> result = this.costTerminalBillVoService.findByConditions(costTerminalBillDto, pageable);
      return Result.ok(result);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
